/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.transport.RemoteServerModelDelegateBase;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelData;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelFields;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.transport.TransportTarget;

public class SimpleRemoteServerModelDelegate
extends RemoteServerModelDelegateBase<SimpleRemoteServerModelData, SimpleRemoteServerModel>
implements SimpleRemoteServerModelFields {
    private TransportTarget myTransportStagingTarget;
    private String myStagingRemotePath;

    public SimpleRemoteServerModelDelegate init(SimpleRemoteServerModel parent) {
        return (SimpleRemoteServerModelDelegate)super.init(parent);
    }

    @Override
    public TransportTarget getTransportStagingTarget() {
        return this.myTransportStagingTarget;
    }

    @Override
    public void setTransportStagingTarget(TransportTarget transportStagingTarget) {
        this.myTransportStagingTarget = transportStagingTarget;
    }

    @Override
    public String getStagingRemotePath() {
        return this.myStagingRemotePath;
    }

    @Override
    public void setStagingRemotePath(String stagingRemotePath) {
        this.myStagingRemotePath = stagingRemotePath;
    }

    @Override
    public String prepareDeployment(String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        this.checkConfiguration();
        return this.prepareDeployment(this.getTransportStagingTarget(), this.getStagingRemotePath(), sourcePath, prepareNameOnly);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getCommonModel().getDeploymentModels().isEmpty()) {
            return;
        }
        this.doCheckConfiguration();
    }

    private void doCheckConfiguration() throws RuntimeConfigurationException {
        this.checkBaseConfiguration();
        TransportTargetKind.STAGING.checkConfiguration(this.getTransportHostId(), this, AppServersCommonBundle.getText("SimpleRemoteStagingEditor.TargetEditor.caption", new Object[0]));
    }

    public boolean isDeployAllowed() {
        try {
            this.doCheckConfiguration();
            return true;
        }
        catch (RuntimeConfigurationException e) {
            return false;
        }
    }

    @Override
    public void readFromData(SimpleRemoteServerModelData data) {
        super.readFromData(data);
        this.myStagingRemotePath = data.getStagingRemotePath();
        this.myTransportStagingTarget = data.getTransportStagingTarget();
    }

    @Override
    public void writeToData(SimpleRemoteServerModelData data) {
        super.writeToData(data);
        data.setStagingRemotePath(this.myStagingRemotePath);
        data.setTransportStagingTarget(this.myTransportStagingTarget);
    }
}

