/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.execution;

import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.execution.KubernetesObjectInfo$;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bBA\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0010\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0011\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J/\u0010\u001a\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\rH\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/view/execution/KubernetesObjectInfo;", "", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "namespace", "", "name", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesEntity;Ljava/lang/String;Ljava/lang/String;)V", "target", "Lio/kubernetes/client/common/KubernetesObject;", "(Lio/kubernetes/client/common/KubernetesObject;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/kubernetes/api/KubernetesEntity;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getEntity", "()Lcom/intellij/kubernetes/api/KubernetesEntity;", "getNamespace", "()Ljava/lang/String;", "getName", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_clouds_kubernetes", "$serializer", "Companion", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
public final class KubernetesObjectInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesEntity<?, ?> entity;
    @NotNull
    private final String namespace;
    @NotNull
    private final String name;

    public KubernetesObjectInfo(@NotNull KubernetesEntity<?, ?> entity, @NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.entity = entity;
        this.namespace = namespace;
        this.name = name;
    }

    @NotNull
    public final KubernetesEntity<?, ?> getEntity() {
        return this.entity;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public KubernetesObjectInfo(@NotNull KubernetesObject target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String string = target.getKind();
        Intrinsics.checkNotNull((Object)string);
        KubernetesEntity<?, ?> kubernetesEntity = KubernetesEntity.Companion.findByKind(string);
        Intrinsics.checkNotNull(kubernetesEntity);
        String string2 = target.getMetadata().getNamespace();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = target.getMetadata().getName();
        Intrinsics.checkNotNull((Object)string3);
        this(kubernetesEntity, string2, string3);
    }

    @NotNull
    public String toString() {
        return "KubernetesObjectInfo(" + this.entity.getKind() + ":" + this.namespace + "/" + this.name + ")";
    }

    @NotNull
    public final KubernetesEntity<?, ?> component1() {
        return this.entity;
    }

    @NotNull
    public final String component2() {
        return this.namespace;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final KubernetesObjectInfo copy(@NotNull KubernetesEntity<?, ?> entity, @NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new KubernetesObjectInfo(entity, namespace, name);
    }

    public static /* synthetic */ KubernetesObjectInfo copy$default(KubernetesObjectInfo kubernetesObjectInfo, KubernetesEntity kubernetesEntity, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            kubernetesEntity = kubernetesObjectInfo.entity;
        }
        if ((n & 2) != 0) {
            string = kubernetesObjectInfo.namespace;
        }
        if ((n & 4) != 0) {
            string2 = kubernetesObjectInfo.name;
        }
        return kubernetesObjectInfo.copy(kubernetesEntity, string, string2);
    }

    public int hashCode() {
        int result = this.entity.hashCode();
        result = result * 31 + this.namespace.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KubernetesObjectInfo)) {
            return false;
        }
        KubernetesObjectInfo kubernetesObjectInfo = (KubernetesObjectInfo)other;
        if (!Intrinsics.areEqual(this.entity, kubernetesObjectInfo.entity)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)kubernetesObjectInfo.namespace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)kubernetesObjectInfo.name);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_clouds_kubernetes(KubernetesObjectInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)KubernetesEntity.Companion.serializer((KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(KubernetesObject.class), new Annotation[0]), (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(KubernetesListObject.class), new Annotation[0])), self.entity);
        output.encodeStringElement(serialDesc, 1, self.namespace);
        output.encodeStringElement(serialDesc, 2, self.name);
    }

    public /* synthetic */ KubernetesObjectInfo(int seen0, KubernetesEntity entity, String namespace, String name, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.entity = entity;
        this.namespace = namespace;
        this.name = name;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/view/execution/KubernetesObjectInfo$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/kubernetes/view/execution/KubernetesObjectInfo;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<KubernetesObjectInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

