/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors.sql.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.sql.generator.SQLGeneratorProcedureCheck;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenObjectConsole;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerCheckProcedureConsole
extends SQLEditorHandlerOpenObjectConsole {
    private static final Log log = Log.getLog(SQLEditorHandlerCheckProcedureConsole.class);

    void openConsoleCheck(IWorkbenchWindow workbenchWindow, DBRRunnableWithResult<String> generator, SQLNavigatorContext navigatorContext, String title, boolean doRun, ISelection currentSelection) throws Exception {
        UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
        String sql = CommonUtils.notEmpty((String)((String)generator.getResult()));
        SQLEditorHandlerCheckProcedureConsole.openAndExecuteSQLScript((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)navigatorContext, (String)title, (boolean)true, (ISelection)currentSelection, (String)sql, (boolean)true);
    }

    @NotNull
    public static SQLGenerator<DBSProcedure> checkGenerator(List<DBSProcedure> entities) {
        SQLGeneratorProcedureCheck procedureCheck = new SQLGeneratorProcedureCheck();
        procedureCheck.initGenerator(entities);
        return procedureCheck;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        SQLNavigatorContext navContext = null;
        String procName = null;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)currentSelection);
        ArrayList<DBSProcedure> entities = new ArrayList<DBSProcedure>();
        for (DBSObject object : selectedObjects) {
            if (!(object instanceof DBSProcedure)) continue;
            DBSProcedure proc = (DBSProcedure)object;
            procName = proc.getName();
            entities.add(proc);
            if (navContext != null) continue;
            navContext = new SQLNavigatorContext(object);
        }
        if (navContext == null || navContext.getDataSourceContainer() == null) {
            log.debug((Object)"No active datasource");
            return null;
        }
        SQLGenerator<DBSProcedure> generator = SQLEditorHandlerCheckProcedureConsole.checkGenerator(entities);
        String title = PostgreMessages.procedure_check_label_ext;
        if (entities.size() == 1 && !CommonUtils.isEmpty((String)procName)) {
            title = NLS.bind((String)PostgreMessages.procedure_check_label2, (Object)procName);
        }
        try {
            UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
            String sql = CommonUtils.notEmpty((String)((String)generator.getResult()));
            SQLEditorHandlerCheckProcedureConsole.openAndExecuteSQLScript((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)navContext, (String)title, (boolean)true, (ISelection)currentSelection, (String)sql, (boolean)true);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(PostgreMessages.message_open_console, PostgreMessages.error_cant_open_sql_editor, (Throwable)e);
        }
        return null;
    }
}

