/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import sun.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    static final boolean VM_SUPPORTS_LONG_CAS;
    private volatile long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long l) {
        this.value = l;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long l) {
        this.value = l;
    }

    public final void lazySet(long l) {
        unsafe.putOrderedLong(this, valueOffset, l);
    }

    public final long getAndSet(long l) {
        return unsafe.getAndSetLong(this, valueOffset, l);
    }

    public final boolean compareAndSet(long l, long l2) {
        return unsafe.compareAndSwapLong(this, valueOffset, l, l2);
    }

    public final boolean weakCompareAndSet(long l, long l2) {
        return unsafe.compareAndSwapLong(this, valueOffset, l, l2);
    }

    public final long getAndIncrement() {
        return unsafe.getAndAddLong(this, valueOffset, 1L);
    }

    public final long getAndDecrement() {
        return unsafe.getAndAddLong(this, valueOffset, -1L);
    }

    public final long getAndAdd(long l) {
        return unsafe.getAndAddLong(this, valueOffset, l);
    }

    public final long incrementAndGet() {
        return unsafe.getAndAddLong(this, valueOffset, 1L) + 1L;
    }

    public final long decrementAndGet() {
        return unsafe.getAndAddLong(this, valueOffset, -1L) - 1L;
    }

    public final long addAndGet(long l) {
        return unsafe.getAndAddLong(this, valueOffset, l) + l;
    }

    public final long getAndUpdate(LongUnaryOperator longUnaryOperator) {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = longUnaryOperator.applyAsLong(l2))) {
        }
        return l2;
    }

    public final long updateAndGet(LongUnaryOperator longUnaryOperator) {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = longUnaryOperator.applyAsLong(l2))) {
        }
        return l;
    }

    public final long getAndAccumulate(long l, LongBinaryOperator longBinaryOperator) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = longBinaryOperator.applyAsLong(l3, l))) {
        }
        return l3;
    }

    public final long accumulateAndGet(long l, LongBinaryOperator longBinaryOperator) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = longBinaryOperator.applyAsLong(l3, l))) {
        }
        return l2;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    static {
        VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicLong.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

