/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.toolbar;

import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.control.icons.CircleFactories;
import com.intellij.cwm.plugin.common.toolbar.DefaultUserManager;
import com.intellij.cwm.plugin.common.toolbar.RdUserActionGroup;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.codeWithMe.model.RdUserModel;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/cwm/plugin/common/users/UserManager;", "user", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "icon", "Ljavax/swing/Icon;", "createJumpToAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createFollowAction", "createFullSyncAction", "startFullSync", "", "createStopFollowingAction", "intellij.cwm.plugin.common"})
public final class CodeWithMeUsersGroupKt {
    @NotNull
    public static final ActionGroup createActionGroup(@NotNull UserManager $this$createActionGroup, @NotNull RdUserModel user, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createActionGroup), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return (ActionGroup)new RdUserActionGroup($this$createActionGroup, user, icon);
    }

    public static /* synthetic */ ActionGroup createActionGroup$default(UserManager userManager, RdUserModel rdUserModel, Icon icon, int n, Object object) {
        if ((n & 2) != 0) {
            icon = CircleFactories.Companion.createUsersIcon(rdUserModel);
        }
        return CodeWithMeUsersGroupKt.createActionGroup(userManager, rdUserModel, icon);
    }

    @NotNull
    public static final AnAction createJumpToAction(@NotNull UserManager $this$createJumpToAction, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createJumpToAction), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Supplier<String> supplier = CodeWithMeUsersGroupKt::createJumpToAction$lambda$0;
        Icon icon = AllIcons.CodeWithMe.CwmJump;
        return (AnAction)new DumbAware($this$createJumpToAction, user, supplier, icon){
            final /* synthetic */ UserManager $this_createJumpToAction;
            final /* synthetic */ RdUserModel $user;
            {
                this.$this_createJumpToAction = $receiver;
                this.$user = $user;
                super($super_call_param$1, $super_call_param$2);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_createJumpToAction.jumpTo(this.$user);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean youFollow = Intrinsics.areEqual((Object)this.$this_createJumpToAction.getLead().getValue(), (Object)this.$user);
                e.getPresentation().setEnabled(!youFollow);
                e.getPresentation().setIcon(ExperimentalUI.Companion.isNewUI() ? null : this.getTemplatePresentation().getIcon());
            }
        };
    }

    @NotNull
    public static final AnAction createFollowAction(@NotNull UserManager $this$createFollowAction, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createFollowAction), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Supplier<String> supplier = CodeWithMeUsersGroupKt::createFollowAction$lambda$1;
        Icon icon = AllIcons.CodeWithMe.CwmFollow;
        var value2 = new DumbAware($this$createFollowAction, user, supplier, icon){
            final /* synthetic */ UserManager $this_createFollowAction;
            final /* synthetic */ RdUserModel $user;
            {
                this.$this_createFollowAction = $receiver;
                this.$user = $user;
                super($super_call_param$1, $super_call_param$2);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_createFollowAction.jumpTo(this.$user);
                this.$this_createFollowAction.startFollowing(this.$user);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean youFollow = Intrinsics.areEqual((Object)this.$this_createFollowAction.getLead().getValue(), (Object)this.$user);
                e.getPresentation().setEnabled(!youFollow);
                e.getPresentation().setIcon(ExperimentalUI.Companion.isNewUI() ? null : this.getTemplatePresentation().getIcon());
            }

            public void setShortcutSet(ShortcutSet shortcutSet) {
                Intrinsics.checkNotNullParameter((Object)shortcutSet, (String)"shortcutSet");
                super.setShortcutSet(shortcutSet);
            }
        };
        UserManager userManager = UserManager.Companion.getInstance($this$createFollowAction.getProject());
        if (DefaultUserManager.Companion.isDefaultFollowee(user, userManager)) {
            String[] stringArray = new String[]{"control shift alt Y"};
            CustomShortcutSet customShortcutSet = CustomShortcutSet.fromString((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)customShortcutSet, (String)"fromString(...)");
            CustomShortcutSet customShortcutSet2 = customShortcutSet;
            value2.setShortcutSet((ShortcutSet)customShortcutSet2);
        }
        return value2;
    }

    @NotNull
    public static final AnAction createFullSyncAction(@NotNull UserManager $this$createFullSyncAction, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createFullSyncAction), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Supplier<String> supplier = CodeWithMeUsersGroupKt::createFullSyncAction$lambda$2;
        Icon icon = AllIcons.CodeWithMe.CwmFullSync;
        return (AnAction)new DumbAware($this$createFullSyncAction, user, supplier, icon){
            final /* synthetic */ UserManager $this_createFullSyncAction;
            final /* synthetic */ RdUserModel $user;
            {
                this.$this_createFullSyncAction = $receiver;
                this.$user = $user;
                super($super_call_param$1, $super_call_param$2);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CodeWithMeUsersGroupKt.startFullSync(this.$this_createFullSyncAction, this.$user);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean fullSyncWith = this.$this_createFullSyncAction.isFullSyncWith(this.$user);
                e.getPresentation().setEnabled(!fullSyncWith);
                e.getPresentation().setIcon(ExperimentalUI.Companion.isNewUI() ? null : this.getTemplatePresentation().getIcon());
            }
        };
    }

    public static final void startFullSync(@NotNull UserManager $this$startFullSync, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$startFullSync), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        $this$startFullSync.jumpTo(user);
        $this$startFullSync.startFollowing(user);
        $this$startFullSync.requestFollowing(user, true);
    }

    @NotNull
    public static final AnAction createStopFollowingAction(@NotNull UserManager $this$createStopFollowingAction, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createStopFollowingAction), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserManager userManager = $this$createStopFollowingAction;
        var value2 = new DumbAware(userManager, user){
            final /* synthetic */ UserManager $userManager;
            final /* synthetic */ RdUserModel $user;
            {
                this.$userManager = $userManager;
                this.$user = $user;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$userManager.stopFollowingOrSync();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean available = Intrinsics.areEqual((Object)this.$userManager.getLead().getValue(), (Object)this.$user);
                e.getPresentation().setEnabledAndVisible(available);
                if (!available) {
                    return;
                }
                boolean isFullSync = this.$userManager.isFullSyncWith(this.$user);
                e.getPresentation().setText(isFullSync ? CodeWithMeCommonBundle.INSTANCE.message("action.stop.fullSync", new Object[0]) : CodeWithMeCommonBundle.INSTANCE.message("action.stop.following", new Object[0]));
            }

            public void setShortcutSet(ShortcutSet shortcutSet) {
                Intrinsics.checkNotNullParameter((Object)shortcutSet, (String)"shortcutSet");
                super.setShortcutSet(shortcutSet);
            }
        };
        if (DefaultUserManager.Companion.isDefaultFollowee(user, userManager)) {
            String[] stringArray = new String[]{"control shift alt Y"};
            CustomShortcutSet customShortcutSet = CustomShortcutSet.fromString((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)customShortcutSet, (String)"fromString(...)");
            CustomShortcutSet customShortcutSet2 = customShortcutSet;
            value2.setShortcutSet((ShortcutSet)customShortcutSet2);
        }
        return value2;
    }

    private static final String createJumpToAction$lambda$0() {
        return CodeWithMeCommonBundle.INSTANCE.message("action.jump.to", new Object[0]);
    }

    private static final String createFollowAction$lambda$1() {
        return CodeWithMeCommonBundle.INSTANCE.message("action.follow", new Object[0]);
    }

    private static final String createFullSyncAction$lambda$2() {
        return CodeWithMeCommonBundle.INSTANCE.message("action.full.sync", new Object[0]);
    }
}

