/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class CompletedFuture<V>
implements Future<V> {
    private final V result;
    private final Throwable exc;

    private CompletedFuture(V v, Throwable throwable) {
        this.result = v;
        this.exc = throwable;
    }

    static <V> CompletedFuture<V> withResult(V v) {
        return new CompletedFuture<V>(v, null);
    }

    static <V> CompletedFuture<V> withFailure(Throwable throwable) {
        if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
            throwable = new IOException(throwable);
        }
        return new CompletedFuture<Object>(null, throwable);
    }

    static <V> CompletedFuture<V> withResult(V v, Throwable throwable) {
        if (throwable == null) {
            return CompletedFuture.withResult(v);
        }
        return CompletedFuture.withFailure(throwable);
    }

    @Override
    public V get() throws ExecutionException {
        if (this.exc != null) {
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException {
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        if (this.exc != null) {
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }
}

