//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package storagepool

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/storagepool/mgmt/2021-04-01-preview/storagepool"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DiskPoolTier = original.DiskPoolTier

const (
	DiskPoolTierBasic    DiskPoolTier = original.DiskPoolTierBasic
	DiskPoolTierPremium  DiskPoolTier = original.DiskPoolTierPremium
	DiskPoolTierStandard DiskPoolTier = original.DiskPoolTierStandard
)

type IscsiTargetACLMode = original.IscsiTargetACLMode

const (
	IscsiTargetACLModeDynamic IscsiTargetACLMode = original.IscsiTargetACLModeDynamic
	IscsiTargetACLModeStatic  IscsiTargetACLMode = original.IscsiTargetACLModeStatic
)

type OperationalStatus = original.OperationalStatus

const (
	OperationalStatusHealthy            OperationalStatus = original.OperationalStatusHealthy
	OperationalStatusInvalid            OperationalStatus = original.OperationalStatusInvalid
	OperationalStatusRunning            OperationalStatus = original.OperationalStatusRunning
	OperationalStatusStopped            OperationalStatus = original.OperationalStatusStopped
	OperationalStatusStoppeddeallocated OperationalStatus = original.OperationalStatusStoppeddeallocated
	OperationalStatusUnhealthy          OperationalStatus = original.OperationalStatusUnhealthy
	OperationalStatusUnknown            OperationalStatus = original.OperationalStatusUnknown
	OperationalStatusUpdating           OperationalStatus = original.OperationalStatusUpdating
)

type ProvisioningStates = original.ProvisioningStates

const (
	ProvisioningStatesCanceled  ProvisioningStates = original.ProvisioningStatesCanceled
	ProvisioningStatesCreating  ProvisioningStates = original.ProvisioningStatesCreating
	ProvisioningStatesDeleting  ProvisioningStates = original.ProvisioningStatesDeleting
	ProvisioningStatesFailed    ProvisioningStates = original.ProvisioningStatesFailed
	ProvisioningStatesInvalid   ProvisioningStates = original.ProvisioningStatesInvalid
	ProvisioningStatesPending   ProvisioningStates = original.ProvisioningStatesPending
	ProvisioningStatesSucceeded ProvisioningStates = original.ProvisioningStatesSucceeded
	ProvisioningStatesUpdating  ProvisioningStates = original.ProvisioningStatesUpdating
)

type ACL = original.ACL
type BaseClient = original.BaseClient
type Disk = original.Disk
type DiskPool = original.DiskPool
type DiskPoolCreate = original.DiskPoolCreate
type DiskPoolCreateProperties = original.DiskPoolCreateProperties
type DiskPoolListResult = original.DiskPoolListResult
type DiskPoolListResultIterator = original.DiskPoolListResultIterator
type DiskPoolListResultPage = original.DiskPoolListResultPage
type DiskPoolProperties = original.DiskPoolProperties
type DiskPoolUpdate = original.DiskPoolUpdate
type DiskPoolUpdateProperties = original.DiskPoolUpdateProperties
type DiskPoolZoneInfo = original.DiskPoolZoneInfo
type DiskPoolZoneListResult = original.DiskPoolZoneListResult
type DiskPoolZoneListResultIterator = original.DiskPoolZoneListResultIterator
type DiskPoolZoneListResultPage = original.DiskPoolZoneListResultPage
type DiskPoolZonesClient = original.DiskPoolZonesClient
type DiskPoolsClient = original.DiskPoolsClient
type DiskPoolsCreateOrUpdateFuture = original.DiskPoolsCreateOrUpdateFuture
type DiskPoolsDeallocateFuture = original.DiskPoolsDeallocateFuture
type DiskPoolsDeleteFuture = original.DiskPoolsDeleteFuture
type DiskPoolsStartFuture = original.DiskPoolsStartFuture
type DiskPoolsUpdateFuture = original.DiskPoolsUpdateFuture
type EndpointDependency = original.EndpointDependency
type EndpointDetail = original.EndpointDetail
type Error = original.Error
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type IscsiLun = original.IscsiLun
type IscsiTarget = original.IscsiTarget
type IscsiTargetCreate = original.IscsiTargetCreate
type IscsiTargetCreateProperties = original.IscsiTargetCreateProperties
type IscsiTargetList = original.IscsiTargetList
type IscsiTargetListIterator = original.IscsiTargetListIterator
type IscsiTargetListPage = original.IscsiTargetListPage
type IscsiTargetProperties = original.IscsiTargetProperties
type IscsiTargetUpdate = original.IscsiTargetUpdate
type IscsiTargetUpdateProperties = original.IscsiTargetUpdateProperties
type IscsiTargetsClient = original.IscsiTargetsClient
type IscsiTargetsCreateOrUpdateFuture = original.IscsiTargetsCreateOrUpdateFuture
type IscsiTargetsDeleteFuture = original.IscsiTargetsDeleteFuture
type IscsiTargetsUpdateFuture = original.IscsiTargetsUpdateFuture
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type OutboundEnvironmentEndpoint = original.OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointList = original.OutboundEnvironmentEndpointList
type OutboundEnvironmentEndpointListIterator = original.OutboundEnvironmentEndpointListIterator
type OutboundEnvironmentEndpointListPage = original.OutboundEnvironmentEndpointListPage
type ProxyResource = original.ProxyResource
type RPOperation = original.RPOperation
type Resource = original.Resource
type Sku = original.Sku
type SystemMetadata = original.SystemMetadata
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDiskPoolListResultIterator(page DiskPoolListResultPage) DiskPoolListResultIterator {
	return original.NewDiskPoolListResultIterator(page)
}
func NewDiskPoolListResultPage(cur DiskPoolListResult, getNextPage func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)) DiskPoolListResultPage {
	return original.NewDiskPoolListResultPage(cur, getNextPage)
}
func NewDiskPoolZoneListResultIterator(page DiskPoolZoneListResultPage) DiskPoolZoneListResultIterator {
	return original.NewDiskPoolZoneListResultIterator(page)
}
func NewDiskPoolZoneListResultPage(cur DiskPoolZoneListResult, getNextPage func(context.Context, DiskPoolZoneListResult) (DiskPoolZoneListResult, error)) DiskPoolZoneListResultPage {
	return original.NewDiskPoolZoneListResultPage(cur, getNextPage)
}
func NewDiskPoolZonesClient(subscriptionID string) DiskPoolZonesClient {
	return original.NewDiskPoolZonesClient(subscriptionID)
}
func NewDiskPoolZonesClientWithBaseURI(baseURI string, subscriptionID string) DiskPoolZonesClient {
	return original.NewDiskPoolZonesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskPoolsClient(subscriptionID string) DiskPoolsClient {
	return original.NewDiskPoolsClient(subscriptionID)
}
func NewDiskPoolsClientWithBaseURI(baseURI string, subscriptionID string) DiskPoolsClient {
	return original.NewDiskPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIscsiTargetListIterator(page IscsiTargetListPage) IscsiTargetListIterator {
	return original.NewIscsiTargetListIterator(page)
}
func NewIscsiTargetListPage(cur IscsiTargetList, getNextPage func(context.Context, IscsiTargetList) (IscsiTargetList, error)) IscsiTargetListPage {
	return original.NewIscsiTargetListPage(cur, getNextPage)
}
func NewIscsiTargetsClient(subscriptionID string) IscsiTargetsClient {
	return original.NewIscsiTargetsClient(subscriptionID)
}
func NewIscsiTargetsClientWithBaseURI(baseURI string, subscriptionID string) IscsiTargetsClient {
	return original.NewIscsiTargetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOutboundEnvironmentEndpointListIterator(page OutboundEnvironmentEndpointListPage) OutboundEnvironmentEndpointListIterator {
	return original.NewOutboundEnvironmentEndpointListIterator(page)
}
func NewOutboundEnvironmentEndpointListPage(cur OutboundEnvironmentEndpointList, getNextPage func(context.Context, OutboundEnvironmentEndpointList) (OutboundEnvironmentEndpointList, error)) OutboundEnvironmentEndpointListPage {
	return original.NewOutboundEnvironmentEndpointListPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDiskPoolTierValues() []DiskPoolTier {
	return original.PossibleDiskPoolTierValues()
}
func PossibleIscsiTargetACLModeValues() []IscsiTargetACLMode {
	return original.PossibleIscsiTargetACLModeValues()
}
func PossibleOperationalStatusValues() []OperationalStatus {
	return original.PossibleOperationalStatusValues()
}
func PossibleProvisioningStatesValues() []ProvisioningStates {
	return original.PossibleProvisioningStatesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
