/*
	Plugin for Opus encoder.

    Test with:
    ./ripperX_plugin_tester "opusenc --bitrate 224 music.wav music.opus" "./ripperX_plugin-opus 123 999"
    123 = begin, 999 = length
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>

#define OPUS_OUTPUT_BUF_LENGTH  	1024
#define PRINTOUT_INTERVAL       	0.5 * 1000000

int opus_read_stat(unsigned int *current)
{
	char temp[OPUS_OUTPUT_BUF_LENGTH];
	int bytes_read;
	char *p;
	char *q;

	// Grab new ouput from 'opus'
	bytes_read = read(0, (void *) temp, sizeof(temp) - 1);
	if (bytes_read > 0)
	{
		temp[bytes_read] = '\0';

		if (p = (char *) strstr(temp, "] "))
		{
			// we found the string we need
			p += 2;
			if (q = (char *) strchr(p, '%'))
			{
				*q = '\0';		// terminate
				//printf ("string = [%s]", p);
				*current = atoi(p);
				return 0;
			}
		}
	}
	return -1;
}

int main(int argc, char **argv)
{
	unsigned int begin, length;
	unsigned int current = 0;

    if (argc < 3)
        return 127;

	sscanf (argv[1], "%d", &begin);
	sscanf (argv[2], "%d", &length);

	while (1)
	{
		if (opus_read_stat(&current) == 0)
			// print message in form [P 0.xxxxx]\n
			printf("[P %f]\n", ((double) current / 100.0));
		usleep(PRINTOUT_INTERVAL);
	}
}
