/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.burningwave.core.Closeable;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.CriteriaWithClassElementsSupplyingSupport;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.concurrent.QueuedTaskExecutor;

public class SearchResult<E>
implements Closeable {
    SearchContext<E> context;
    ClassPathScanner.Abst<E, ?, ?> classPathScanner;

    SearchResult(SearchContext<E> context) {
        this.context = context;
    }

    void setClassPathScanner(ClassPathScanner.Abst<E, ?, ?> classPathScanner) {
        this.classPathScanner = classPathScanner;
        classPathScanner.register(this);
    }

    Collection<E> getItemsFound() {
        return this.context.getItemsFound();
    }

    Map<String, E> getItemsFoundFlatMap() {
        return this.context.getItemsFoundFlatMap();
    }

    <C extends CriteriaWithClassElementsSupplyingSupport<E, C, T>, T extends Criteria.TestContext<E, C>> C createCriteriaCopy(C criteria) {
        Object criteriaCopy = ((CriteriaWithClassElementsSupplyingSupport)criteria.createCopy()).init(this.context.getSearchConfig().getClassCriteria().getClassSupplier(), this.context.getSearchConfig().getClassCriteria().getByteCodeSupplier());
        Optional.ofNullable(this.context.getSearchConfig().getClassCriteria().getClassesToBeUploaded()).ifPresent(classesToBeUploaded -> criteriaCopy.useClasses((Collection<Class<?>>)classesToBeUploaded));
        return criteriaCopy;
    }

    <M extends Member, C extends MemberCriteria<M, C, T>, T extends Criteria.TestContext<M, C>> C createCriteriaCopy(C criteria) {
        MemberCriteria criteriaCopy = (MemberCriteria)criteria.createCopy().init(this.context.getSearchConfig().getClassCriteria().getClassSupplier(), this.context.getSearchConfig().getClassCriteria().getByteCodeSupplier());
        Optional.ofNullable(this.context.getSearchConfig().getClassCriteria().getClassesToBeUploaded()).ifPresent(classesToBeUploaded -> criteriaCopy.useClasses((Collection<Class<?>>)classesToBeUploaded));
        return (C)criteriaCopy;
    }

    <C extends ClassLoader> C getUsedClassLoader() {
        return (C)this.context.pathScannerClassLoader;
    }

    public <C extends CriteriaWithClassElementsSupplyingSupport<E, C, T>, T extends Criteria.TestContext<E, C>> Map<String, E> getClasses(C criteria) {
        try (CriteriaWithClassElementsSupplyingSupport criteriaCopy = this.createCriteriaCopy(criteria);){
            HashMap itemsFound = new HashMap();
            this.getItemsFoundFlatMap().forEach((path, javaClass) -> {
                if (((Criteria.TestContext)criteriaCopy.testWithFalseResultForNullEntityOrTrueResultForNullPredicate(javaClass)).getResult().booleanValue()) {
                    itemsFound.put(path, javaClass);
                }
            });
            HashMap hashMap = itemsFound;
            return hashMap;
        }
    }

    public <C extends CriteriaWithClassElementsSupplyingSupport<E, C, T>, T extends Criteria.TestContext<E, C>> Map.Entry<String, E> getUnique(C criteria) {
        Map<String, E> itemsFound = this.getClasses(criteria);
        if (itemsFound.size() > 1) {
            StaticComponentContainer.Driver.throwException("Found more than one element", new Object[0]);
        }
        return itemsFound.entrySet().stream().findFirst().orElseGet(() -> null);
    }

    public void waitForSearchEnding() {
        this.context.waitForSearchEnding();
    }

    public Collection<String> getSkippedClassNames() {
        return this.context.getSkippedClassNames();
    }

    public QueuedTaskExecutor.Task getSearchTask() {
        return this.context.getSearchTask();
    }

    public void setRequestToClosePathScannerClassLoaderOnClose(boolean flag) {
        this.context.setrequestToClosePathScannderClassLoaderOnClose(flag);
    }

    @Override
    public void close() {
        this.context.close();
        this.context = null;
        this.classPathScanner.unregister(this);
        this.classPathScanner = null;
    }
}

