/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import java.util.Map;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.draw2d.TestCaseRootFigure;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.Test;

public class RootFigureTest
extends Draw2dFigureTestCase {
    @Test
    public void test_getPreferredSize_setBounds() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        DeferredUpdateManager updateManager = new DeferredUpdateManager();
        TestLogger expectedLogger = new TestLogger();
        RootFigure testRoot = new RootFigure(null, (UpdateManager)updateManager){
            private final /* synthetic */ UpdateManager val$updateManager;
            {
                this.val$updateManager = updateManager;
                super($anonymous0);
            }

            public UpdateManager getUpdateManager() {
                return this.val$updateManager;
            }
        };
        testRoot.getUpdateManager().addUpdateListener(new UpdateListener(){

            public void notifyPainting(Rectangle damage, Map dirtyRegions) {
                actualLogger.log("refreshRequest(" + damage.x + ", " + damage.y + ", " + damage.width + ", " + damage.height + ")");
            }

            public void notifyValidating() {
            }
        });
        Layer layer0 = new Layer("Main");
        Figure figure0 = new Figure();
        figure0.setBounds(new Rectangle(10, 10, 100, 200));
        layer0.add((IFigure)figure0);
        testRoot.addLayer(layer0);
        Layer layer1 = new Layer("Feedback");
        Figure figure1 = new Figure();
        figure1.setBounds(new Rectangle(50, 70, 120, 90));
        layer1.add((IFigure)figure1);
        testRoot.addLayer(layer1);
        actualLogger.clear();
        Dimension preferredSize = testRoot.getPreferredSize();
        RootFigureTest.assertEquals((Object)new Dimension(170, 210), (Object)preferredSize);
        testRoot.setBounds(new Rectangle(0, 0, 180, 150));
        actualLogger.assertEmpty();
        RootFigureTest.assertEquals((Object)new Rectangle(0, 0, 180, 210), (Object)testRoot.getBounds());
        RootFigureTest.assertEquals((Object)new Rectangle(0, 0, 180, 210), (Object)layer0.getBounds());
        RootFigureTest.assertEquals((Object)new Rectangle(10, 10, 100, 200), (Object)figure0.getBounds());
        RootFigureTest.assertEquals((Object)new Rectangle(0, 0, 180, 210), (Object)layer1.getBounds());
        RootFigureTest.assertEquals((Object)new Rectangle(50, 70, 120, 90), (Object)figure1.getBounds());
        RootFigureTest.assertSame((Object)preferredSize, (Object)testRoot.getPreferredSize());
        figure1.repaint();
        RootFigureTest.waitEventLoop(10);
        expectedLogger.log("refreshRequest(50, 70, 120, 90)");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertSame((Object)preferredSize, (Object)testRoot.getPreferredSize());
        figure0.revalidate();
        figure0.repaint();
        RootFigureTest.waitEventLoop(10);
        expectedLogger.log("refreshRequest(10, 10, 100, 200)");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertNotSame((Object)preferredSize, (Object)testRoot.getPreferredSize());
        RootFigureTest.assertEquals((Object)preferredSize, (Object)testRoot.getPreferredSize());
    }

    @Test
    public void test_findTargetFigure() throws Exception {
        Layer layer1 = new Layer("1");
        Figure figure11 = new Figure(){

            public String toString() {
                return "figure11";
            }
        };
        layer1.add((IFigure)figure11, (Object)new Rectangle(10, 10, 200, 150));
        Figure figure12 = new Figure(){

            public String toString() {
                return "figure12";
            }
        };
        layer1.add((IFigure)figure12, (Object)new Rectangle(400, 300, 50, 70));
        Layer layer2 = new Layer("2");
        Figure figure21 = new Figure(){

            public String toString() {
                return "figure21";
            }
        };
        layer2.add((IFigure)figure21, (Object)new Rectangle(50, 50, 90, 60));
        Figure figure22 = new Figure(){

            public String toString() {
                return "figure22";
            }
        };
        layer2.add((IFigure)figure22, (Object)new Rectangle(150, 250, 190, 120));
        Figure figure23 = new Figure(){

            public String toString() {
                return "figure23";
            }
        };
        figure22.add((IFigure)figure23, (Object)new Rectangle(15, 25, 19, 12));
        DeferredUpdateManager updateManager = new DeferredUpdateManager();
        RootFigure testRoot = new RootFigure(null, (UpdateManager)updateManager){
            private final /* synthetic */ UpdateManager val$updateManager;
            {
                this.val$updateManager = updateManager;
                super($anonymous0);
            }

            public UpdateManager getUpdateManager() {
                return this.val$updateManager;
            }

            public void repaint(int x, int y, int width, int height) {
            }
        };
        testRoot.addLayer(layer1);
        testRoot.addLayer(layer2);
        testRoot.setBounds(new Rectangle(0, 0, 500, 400));
    }

    @Test
    public void test_addLayer_getLayer() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure testRoot = new TestCaseRootFigure(actualLogger);
        TestLogger expectedLogger = new TestLogger();
        try {
            testRoot.addLayer(null);
            RootFigureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        RootFigureTest.assertEquals((int)0, (int)testRoot.getLayers().size());
        Layer layer0 = new Layer("Main");
        testRoot.addLayer(layer0);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertSame((Object)((Object)testRoot), (Object)layer0.getParent());
        RootFigureTest.assertEquals((int)1, (int)testRoot.getLayers().size());
        Layer layer1 = new Layer("Feedback");
        testRoot.addLayer(layer1);
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertSame((Object)((Object)testRoot), (Object)layer1.getParent());
        RootFigureTest.assertEquals((int)2, (int)testRoot.getLayers().size());
        RootFigureTest.assertSame((Object)layer0, testRoot.getLayers().get(0));
        RootFigureTest.assertSame((Object)layer1, testRoot.getLayers().get(1));
        RootFigureTest.assertSame((Object)layer0, (Object)testRoot.getLayer("Main"));
        RootFigureTest.assertSame((Object)layer1, (Object)testRoot.getLayer("Feedback"));
        RootFigureTest.assertNull((Object)testRoot.getLayer("feedback"));
        RootFigureTest.assertNull((Object)testRoot.getLayer(null));
    }

    @Test
    public void test_remove() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure testRoot = new TestCaseRootFigure(actualLogger);
        TestLogger expectedLogger = new TestLogger();
        Layer layer0 = new Layer("Feedback");
        testRoot.addLayer(layer0);
        actualLogger.clear();
        try {
            testRoot.removeLayer(null);
            RootFigureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            testRoot.removeLayer("feedback");
            RootFigureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Layer layer1 = new Layer("feedback");
        testRoot.addLayer(layer1);
        actualLogger.clear();
        testRoot.removeLayer(layer0);
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertNull((Object)layer0.getParent());
        RootFigureTest.assertEquals((int)1, (int)testRoot.getLayers().size());
        RootFigureTest.assertNull((Object)testRoot.getLayer("Feedback"));
        testRoot.removeLayer("feedback");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertNull((Object)layer0.getParent());
        RootFigureTest.assertEquals((int)0, (int)testRoot.getLayers().size());
        RootFigureTest.assertNull((Object)testRoot.getLayer("feedback"));
    }

    @Test
    public void test_removeAll() throws Exception {
        TestLogger actualLogger = new TestLogger();
        TestCaseRootFigure testRoot = new TestCaseRootFigure(actualLogger);
        TestLogger expectedLogger = new TestLogger();
        testRoot.removeAll();
        actualLogger.assertEmpty();
        Layer layer0 = new Layer("Main");
        testRoot.addLayer(layer0);
        Layer layer1 = new Layer("Feedback");
        testRoot.addLayer(layer1);
        actualLogger.clear();
        testRoot.removeAll();
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        expectedLogger.log("repaint(0, 0, 0, 0)");
        expectedLogger.log("invalidate");
        actualLogger.assertEquals(expectedLogger);
        RootFigureTest.assertNull((Object)layer0.getParent());
        RootFigureTest.assertNull((Object)testRoot.getLayer("Main"));
        RootFigureTest.assertNull((Object)layer1.getParent());
        RootFigureTest.assertNull((Object)testRoot.getLayer("Feedback"));
        testRoot.removeAll();
        actualLogger.assertEmpty();
    }
}

