/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowDataInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_setLayout_single() throws Exception {
        this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        LayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new RowLayout())/}", "  {new: org.eclipse.swt.layout.RowLayout} {empty} {/setLayout(new RowLayout())/}");
    }

    @Test
    public void test_parse_setLayout_double() throws Exception {
        try {
            this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    setLayout(new FillLayout());", "  }", "}");
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            LayoutTest.assertEquals((int)2004, (int)e.getCode());
        }
    }

    @Test
    public void test_isActive() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        LayoutInfo oldLayout = shell.getLayout();
        LayoutTest.assertTrue((boolean)oldLayout.isActive());
        LayoutInfo newLayout = (LayoutInfo)LayoutTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        LayoutTest.assertFalse((boolean)newLayout.isActive());
        shell.setLayout(newLayout);
        LayoutTest.assertFalse((boolean)oldLayout.isActive());
        LayoutTest.assertTrue((boolean)newLayout.isActive());
        newLayout.delete();
        LayoutTest.assertTrue((boolean)oldLayout.isActive());
        LayoutTest.assertFalse((boolean)newLayout.isActive());
    }

    @Test
    public void test_changeLayout() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    RowLayout layout = new RowLayout();", "    shell.setLayout(layout);", "    //", "    Button button = new Button(shell, SWT.NONE);", "    RowData data = new RowData();", "    data.width = 50;", "    data.height = 40;", "    button.setLayoutData(data);", "  }", "}");
        RowLayoutInfo layoutInfo = (RowLayoutInfo)shellInfo.getLayout();
        LayoutTest.assertNotNull((Object)layoutInfo);
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        RowDataInfo dataInfo = (RowDataInfo)buttonInfo.getChildrenJava().get(0);
        LayoutTest.assertNotNull((Object)dataInfo);
        FillLayoutInfo newLayout = (FillLayoutInfo)LayoutTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        shellInfo.setLayout((LayoutInfo)newLayout);
        LayoutTest.assertSame((Object)newLayout, (Object)shellInfo.getLayout());
        for (ObjectInfo child : shellInfo.getChildren()) {
            LayoutTest.assertFalse((boolean)(child instanceof GridLayoutInfo));
        }
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout(SWT.HORIZONTAL));", "    //", "    Button button = new Button(shell, SWT.NONE);", "  }", "}");
        LayoutTest.assertTrue((boolean)buttonInfo.getChildrenJava().isEmpty());
    }

    @Test
    public void test_visualInheritance_withOverride() throws Exception {
        LayoutTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    init();", "  }", "  protected void init() {", "    setLayout(new FillLayout());", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void init() {", "    super.init();", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.MyComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}");
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_isManagedObject_simpleFalse() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        LayoutInfo layout = shell.getLayout();
        Object newObject = LayoutTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        LayoutTest.assertFalse((boolean)layout.isManagedObject(newObject));
        newObject = BTestUtils.createButton();
        LayoutTest.assertFalse((boolean)layout.isManagedObject(newObject));
    }

    @Test
    public void test_isManagedObject_simpleTrue() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)LayoutTest.getJavaInfoByName("button");
        LayoutInfo layout = shell.getLayout();
        LayoutTest.assertTrue((boolean)layout.isManagedObject((Object)button));
    }

    @Test
    public void test_isManagedObject_falseBecauseNotActive() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        ControlInfo button = (ControlInfo)LayoutTest.getJavaInfoByName("button");
        LayoutInfo oldLayout = shell.getLayout();
        LayoutInfo newLayout = (LayoutInfo)LayoutTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        shell.setLayout(newLayout);
        LayoutTest.assertFalse((boolean)oldLayout.isActive());
        LayoutTest.assertTrue((boolean)newLayout.isActive());
        LayoutTest.assertFalse((boolean)oldLayout.isManagedObject((Object)button));
        LayoutTest.assertTrue((boolean)newLayout.isManagedObject((Object)button));
    }

    @Test
    public void test_hasImplicitControls_RowLayout() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "    new Button(this, SWT.NONE);", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.RowLayout} {implicit-layout} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasImplicitControls_GridLayout() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    new Button(this, SWT.NONE);", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasImplicitControls_directExposedChild() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private Button m_button;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      m_button = new Button(this, SWT.NONE);", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {method: public org.eclipse.swt.widgets.Button test.ImplicitComposite.getButton()} {property} {}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        LayoutInfo layout = composite.getLayout();
        Assertions.assertThat((List)layout.getControls()).hasSize(1);
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasImplicitControls_indirectExposedChild() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private Button m_button;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Composite container = new Composite(this, SWT.NONE);", "      container.setLayout(new RowLayout());", "      {", "        m_button = new Button(container, SWT.NONE);", "        m_button.setLayoutData(new RowData());", "      }", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {method: public org.eclipse.swt.widgets.Button test.ImplicitComposite.getButton()} {property} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        LayoutInfo layout = composite.getLayout();
        Assertions.assertThat((List)layout.getControls()).isEmpty();
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasImplicitControls_directExposedChild_Viewer() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private TableViewer m_viewer;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      m_viewer = new TableViewer(this, SWT.NONE);", "    }", "  }", "  public TableViewer getViewer() {", "    return m_viewer;", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "    {method: public org.eclipse.jface.viewers.TableViewer test.ImplicitComposite.getViewer()} {property} {}", "    {virtual-layout_data: org.eclipse.swt.layout.GridData} {virtual-layout-data} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        LayoutInfo layout = composite.getLayout();
        Assertions.assertThat((List)layout.getControls()).hasSize(1);
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_hasImplicitControls_indirectExposedChild_Viewer() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private TableViewer m_viewer;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Composite container = new Composite(this, SWT.NONE);", "      container.setLayout(new RowLayout());", "      {", "        m_viewer = new TableViewer(container, SWT.NONE);", "      }", "    }", "  }", "  public TableViewer getViewer() {", "    return m_viewer;", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {viewer: public org.eclipse.swt.widgets.Table org.eclipse.jface.viewers.TableViewer.getTable()} {viewer} {}", "    {method: public org.eclipse.jface.viewers.TableViewer test.ImplicitComposite.getViewer()} {property} {}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        LayoutInfo layout = composite.getLayout();
        Assertions.assertThat((List)layout.getControls()).isEmpty();
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_indirectExposedChildren_andLocalLayoutData() throws Exception {
        LayoutTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  private Button m_button;", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Composite container = new Composite(this, SWT.NONE);", "      container.setLayout(new RowLayout());", "      {", "        m_button = new Button(container, SWT.NONE);", "        m_button.setLayoutData(new RowData());", "      }", "    }", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        LayoutTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData());", "    }", "  }", "}");
        LayoutTest.assertHierarchy("{this: test.ImplicitComposite} {this} {/new Text(this, SWT.BORDER)/}", "  {implicit-layout: org.eclipse.swt.layout.GridLayout} {implicit-layout} {}", "  {method: public org.eclipse.swt.widgets.Button test.ImplicitComposite.getButton()} {property} {}", "  {new: org.eclipse.swt.widgets.Text} {local-unique: text} {/new Text(this, SWT.BORDER)/ /text.setLayoutData(new GridData())/}", "    {new: org.eclipse.swt.layout.GridData} {empty} {/text.setLayoutData(new GridData())/}");
        LayoutTest.assertTrue((boolean)composite.hasLayout());
        composite.refresh();
        LayoutTest.assertNoErrors((JavaInfo)composite);
    }

    private void check_nameTemplate(String template, String ... lines) throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout(SWT.HORIZONTAL));", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        LayoutInfo layout = composite.getLayout();
        RcpToolkitDescription.INSTANCE.getPreferences().setValue("templateLayoutName", template);
        layout.getPropertyByTitle("spacing").setValue((Object)5);
        this.assertEditor(lines);
    }

    @Test
    public void test_nameTemplate_useDefaultName() throws Exception {
        this.check_nameTemplate("${defaultName}", "class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      FillLayout fillLayout = new FillLayout(SWT.HORIZONTAL);", "      fillLayout.spacing = 5;", "      composite.setLayout(fillLayout);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_1() throws Exception {
        this.check_nameTemplate("${layoutAcronym}_${compositeName}", "class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      FillLayout fl_composite = new FillLayout(SWT.HORIZONTAL);", "      fl_composite.spacing = 5;", "      composite.setLayout(fl_composite);", "    }", "  }", "}");
    }

    @Test
    public void test_nameTemplate_alternativeTemplate_2() throws Exception {
        this.check_nameTemplate("${compositeName}${layoutClassName}", "class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      FillLayout compositeFillLayout = new FillLayout(SWT.HORIZONTAL);", "      compositeFillLayout.spacing = 5;", "      composite.setLayout(compositeFillLayout);", "    }", "  }", "}");
    }
}

