/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gef;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.jupiter.api.Test;

public class GridLayoutPolicyTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        String source = "// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}";
        String source2 = "// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(1, 0, 0, 0));\n\t}\n}";
        this.check_setLayout(source, "java.awt.GridLayout", source2, 10, 10);
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 3));\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 3));\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 3));\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 1\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 2\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_1, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridLayout(0, 3));\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 2\");\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button 1\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setLayout(new GridLayout(0, 3));\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setLayout(new GridLayout(0, 3));\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"Button\");\n\t\t\t\tpanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
    }
}

