/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class MigLayoutAutoAlignmentTest
extends AbstractMigLayoutTest {
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("MigLayout.enableGrab");
        preferences.setToDefault("MigLayout.enableRightAlignment");
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JTextField.class);
        layout.command_CREATE(newComponent, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[grow]', '[]'));", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 0 0,growx');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        Activator.getDefault().getPreferenceStore().setValue("MigLayout.enableGrab", false);
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JTextField.class);
        layout.command_CREATE(newComponent, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 0 0');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JTable.class);
        layout.command_CREATE(newComponent, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[grow]', '[grow]'));", "    {", "      JTable table = new JTable();", "      add(table, 'cell 0 0,grow');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 1 0, growx');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JLabel.class);
        layout.command_CREATE(newComponent, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, 'cell 0 0,alignx trailing');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 1 0, growx');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 1 0, growx');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        Activator.getDefault().getPreferenceStore().setValue("MigLayout.enableRightAlignment", false);
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JLabel.class);
        layout.command_CREATE(newComponent, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, 'cell 0 0');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 1 0, growx');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_TextAfterLabel() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = MigLayoutAutoAlignmentTest.createComponent(JTextField.class);
        layout.command_CREATE(newComponent, 1, false, 0, false);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][grow]', '[]'));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, 'cell 0 0,alignx trailing');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, 'cell 1 0,growx');", "      textField.setColumns(10);", "    }", "  }", "}");
    }
}

