/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.property;

import java.util.List;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.model.property.CursorPropertyEditorTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CursorPropertyEditorWithManagerTest
extends CursorPropertyEditorTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        CursorPropertyEditorWithManagerTest.do_projectDispose();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_null() throws Exception {
        this.assert_getText_getClipboardSource_forSource("null", null, null);
    }

    @Test
    public void test_useConstructor() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Cursor(null, SWT.CURSOR_WAIT)", "CURSOR_WAIT", "org.eclipse.swt.widgets.Display.getCurrent().getSystemCursor(org.eclipse.swt.SWT.CURSOR_WAIT)");
    }

    @Test
    public void test_useConstructor_notStyle() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Cursor(null, 1/*SWT.CURSOR_WAIT*/)", null, null);
    }

    @Test
    public void test_combo() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.addMethodInvocation("setCursor(org.eclipse.swt.graphics.Cursor)", "org.eclipse.swt.widgets.Display.getCurrent().getSystemCursor(org.eclipse.swt.SWT.CURSOR_CROSS)");
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setCursor(Display.getCurrent().getSystemCursor(SWT.CURSOR_CROSS));", "  }", "}");
        shell.refresh();
        Property property = shell.getPropertyByTitle("cursor");
        CursorPropertyEditorWithManagerTest.addComboPropertyItems(property);
        List<String> items = CursorPropertyEditorWithManagerTest.getComboPropertyItems();
        CursorPropertyEditorWithManagerTest.assertEquals((Object)"CURSOR_ARROW", (Object)items.get(0));
        CursorPropertyEditorWithManagerTest.assertEquals((Object)"CURSOR_WAIT", (Object)items.get(1));
        CursorPropertyEditorWithManagerTest.assertEquals((Object)"CURSOR_CROSS", (Object)items.get(2));
        CursorPropertyEditorWithManagerTest.assertEquals((Object)"CURSOR_HELP", (Object)items.get(4));
        CursorPropertyEditorWithManagerTest.setComboPropertySelection(1);
        CursorPropertyEditorWithManagerTest.setComboPropertySelection(property);
        CursorPropertyEditorWithManagerTest.assertEquals((int)2, (int)CursorPropertyEditorWithManagerTest.getComboPropertySelection());
        CursorPropertyEditorWithManagerTest.setComboPropertyValue(property, 4);
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setCursor(Display.getCurrent().getSystemCursor(SWT.CURSOR_HELP));", "  }", "}");
    }

    @Test
    public void test_setValue_ensureManager() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.refresh();
        Property property = shell.getPropertyByTitle("cursor");
        PropertyEditor propertyEditor = property.getEditor();
        ReflectionUtils.invokeMethod((Object)propertyEditor, (String)"toPropertyEx(org.eclipse.wb.internal.core.model.property.Property,org.eclipse.wb.core.controls.CCombo3,int)", (Object[])new Object[]{property, null, 0});
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setCursor(Display.getCurrent().getSystemCursor(SWT.CURSOR_ARROW));", "  }", "}");
    }
}

