/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.rcp.model.jface.ApplicationWindowInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class ApplicationWindowGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_barCreate_Shell() throws Exception {
        CompositeInfo shell = this.openComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        MenuInfo newMenu = (MenuInfo)this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.canvas.assertNoFeedbacks();
        this.canvas.moveTo(shell);
        this.canvas.assertFeedbacks(t -> t.getSize().width > 200);
        this.canvas.click();
        this.canvas.assertNoFeedbacks();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "    }", "  }", "}");
        this.canvas.assertPrimarySelected(newMenu);
    }

    @Test
    public void test_barCreate_ApplicationWindow() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.openJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void configureShell(Shell newShell) {", "    super.configureShell(newShell);", "  }", "}");
        String source = this.m_lastEditor.getSource();
        ShellInfo shell = (ShellInfo)window.getChildren(ShellInfo.class).get(0);
        this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.canvas.target(shell).in(100, 100).move();
        this.canvas.assertNoFeedbacks();
        this.canvas.assertCommandNull();
        this.canvas.click();
        ApplicationWindowGefTest.assertEditor(source, this.m_lastEditor);
        this.loadCreationTool("org.eclipse.swt.widgets.Menu", "bar");
        this.tree.moveOn(shell);
        this.tree.assertFeedback_empty();
        this.tree.assertCommandNull();
        this.tree.click();
        ApplicationWindowGefTest.assertEditor(source, this.m_lastEditor);
    }

    @Test
    public void test_clickOn_createContents_parent() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.openJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected Control createContents(Composite parent) {", "    Composite container = new Composite(parent, SWT.NONE);", "    return container;", "  }", "}");
        ApplicationWindowGefTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}", "  {parameter} {parent} {/new Composite(parent, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NONE)/ /container/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        this.canvas.target(window).in(100, 1).move().click();
        this.canvas.assertPrimarySelected(window);
    }

    @Test
    public void test_clickOn_configureShell_newShell() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.openJavaInfo("import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "  protected void configureShell(Shell newShell) {", "    super.configureShell(newShell);", "  }", "}");
        ApplicationWindowGefTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}", "  {parameter} {newShell} {/super.configureShell(newShell)/}");
        this.canvas.target(window).in(100, 10).move().click();
        this.canvas.assertPrimarySelected(window);
    }

    @DisposeProjectAfter
    @Test
    public void test_disposedImageOfAction() throws Exception {
        ManagerUtils.ensure_ResourceManager((IJavaProject)m_javaProject, (ToolkitDescription)RcpToolkitDescription.INSTANCE);
        TestUtils.createImagePNG(m_testProject, "src/test/images/test.png", 16, 16);
        this.openJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      m_action = new Action('The text') {", "        public void run() {", "        }", "      };", "      m_action.setImageDescriptor(org.eclipse.wb.swt.ResourceManager.getImageDescriptor(Test.class, 'images/test.png'));", "    }", "  }", "}");
        ActionInfo action = (ActionInfo)ApplicationWindowGefTest.getJavaInfoByName("m_action");
        action.getPropertyByTitle("enabled").setValue((Object)false);
        ApplicationWindowGefTest.waitEventLoop(0);
    }

    @DisposeProjectAfter
    @Test
    public void test_usingDisposedImage_inComponentsTree() throws Exception {
        ManagerUtils.ensure_ResourceManager((IJavaProject)m_javaProject, (ToolkitDescription)RcpToolkitDescription.INSTANCE);
        TestUtils.createImagePNG(m_testProject, "src/test/images/test.png", 16, 16);
        this.openJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "import org.eclipse.wb.swt.ResourceManager;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  private IAction m_action2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Action 1') {", "        public void run() {", "        }", "      };", "      m_action.setImageDescriptor(ResourceManager.getImageDescriptor(Test.class,'images/test.png'));", "    }", "    {", "      m_action2 = new Action('Action 2') {", "        public void run() {", "        }", "      };", "    }", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = new MenuManager('menu');", "    {", "      MenuManager menuManager_1 = new MenuManager('New MenuManager');", "      menuManager.add(menuManager_1);", "      menuManager_1.add(m_action);", "      menuManager_1.add(m_action2);", "    }", "    return menuManager;", "  }", "}");
        ActionInfo action2 = (ActionInfo)ApplicationWindowGefTest.getJavaInfoByName("m_action2");
        this.m_viewerTree.getTree().setFocus();
        this.tree.expandAll();
        this.tree.select(action2);
        action2.delete();
        ApplicationWindowGefTest.waitEventLoop(0);
    }
}

