/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapColumnInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapRowInfo;
import org.eclipse.wb.internal.swt.model.jface.viewer.ViewerInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.eclipse.wb.tests.designer.swt.model.jface.ViewerTest;
import org.junit.jupiter.api.Test;

public class TableWrapLayoutTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parseEmpty() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setLayout(new TableWrapLayout());", "  }", "}");
        shell.refresh();
        shell.refresh_dispose();
    }

    @Test
    public void test_excludeFillersFromPresentationChildren() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        try {
            TableWrapLayoutTest.assertEquals((int)2, (int)shell.getChildrenControls().size());
            ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
            ControlInfo filler = (ControlInfo)shell.getChildrenControls().get(1);
            IObjectPresentation presentation = shell.getPresentation();
            List presentationChildren = presentation.getChildrenTree();
            TableWrapLayoutTest.assertTrue((boolean)presentationChildren.contains(button));
            TableWrapLayoutTest.assertFalse((boolean)presentationChildren.contains(filler));
            presentationChildren = presentation.getChildrenGraphical();
            TableWrapLayoutTest.assertTrue((boolean)presentationChildren.contains(button));
            TableWrapLayoutTest.assertFalse((boolean)presentationChildren.contains(filler));
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_gridInfo() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.colspan = 2;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button_0 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(3);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(4);
        shell.refresh();
        try {
            IGridInfo gridInfo = layout.getGridInfo();
            TableWrapLayoutTest.assertNotNull((Object)gridInfo);
            TableWrapLayoutTest.assertEquals((int)2, (int)gridInfo.getColumnCount());
            TableWrapLayoutTest.assertEquals((int)3, (int)gridInfo.getRowCount());
            int[] columnOrigins = layout.getColumnOrigins();
            Interval[] columnIntervals = gridInfo.getColumnIntervals();
            TableWrapLayoutTest.assertEquals((int)columnOrigins.length, (int)columnIntervals.length);
            int i = 0;
            while (i < columnOrigins.length) {
                int origin = columnOrigins[i];
                Interval interval = columnIntervals[i];
                TableWrapLayoutTest.assertEquals((int)origin, (int)interval.begin());
                ++i;
            }
            int[] rowOrigins = layout.getRowOrigins();
            Interval[] rowIntervals = gridInfo.getRowIntervals();
            TableWrapLayoutTest.assertEquals((int)rowOrigins.length, (int)rowIntervals.length);
            TableWrapLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_0));
            TableWrapLayoutTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
            TableWrapLayoutTest.assertEquals((Object)new Rectangle(0, 2, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_2));
            Rectangle rectangle = gridInfo.getCellsRectangle(new Rectangle(0, 0, 1, 1));
            TableWrapLayoutTest.assertEquals((int)5, (int)rectangle.x);
            TableWrapLayoutTest.assertEquals((int)5, (int)rectangle.y);
            TableWrapLayoutTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)gridInfo.getInsets());
            TableWrapLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualColumnSize());
            TableWrapLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualColumnGap());
            TableWrapLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualRowSize());
            TableWrapLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualRowGap());
            TableWrapLayoutTest.assertSame((Object)button_0, (Object)gridInfo.getOccupied(0, 0));
            TableWrapLayoutTest.assertSame((Object)button_1, (Object)gridInfo.getOccupied(1, 1));
            TableWrapLayoutTest.assertSame((Object)button_2, (Object)gridInfo.getOccupied(0, 2));
            TableWrapLayoutTest.assertSame((Object)button_2, (Object)gridInfo.getOccupied(1, 2));
            TableWrapLayoutTest.assertNull((Object)gridInfo.getOccupied(1, 0));
            TableWrapLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_gridInfo2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    setSize(300, 200);", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button_0 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(1);
        shell.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        TableWrapLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_0));
        TableWrapLayoutTest.assertEquals((Object)new Rectangle(0, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
    }

    @Test
    public void test_gridInfo_empty() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            IGridInfo gridInfo = layout.getGridInfo();
            TableWrapLayoutTest.assertEquals((int)0, (int)gridInfo.getRowIntervals().length);
            TableWrapLayoutTest.assertEquals((int)0, (int)gridInfo.getColumnIntervals().length);
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_setCells_horizontalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        try {
            TableWrapDataInfo layoutData = layout.getTableWrapData(button);
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "width"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "height"));
            layout.command_setCells(button, new Rectangle(0, 0, 2, 1), true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 2));", "      button.setText('000');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            TableWrapLayoutTest.assertEquals((int)2, (int)TableWrapLayoutTest.getInt(layoutData, "width"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "height"));
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_setCells_horizontalSpan2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 2);", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        layout.command_setCells(button, new Rectangle(0, 0, 1, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_verticalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        try {
            TableWrapDataInfo layoutData = layout.getTableWrapData(button);
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "width"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "height"));
            layout.command_setCells(button, new Rectangle(0, 0, 1, 2), true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1));", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "width"));
            TableWrapLayoutTest.assertEquals((int)2, (int)TableWrapLayoutTest.getInt(layoutData, "height"));
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_setCells_verticalSpan2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1);", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('111');", "    }", "    new Label(this, SWT.RIGHT);", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        layout.command_setCells(button, new Rectangle(1, 1, 1, 1), true);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
    }

    @Test
    public void test_setCells_move() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        shell.refresh();
        try {
            layout.command_setCells(button, new Rectangle(1, 0, 1, 1), true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
            ControlInfo filler = (ControlInfo)shell.getChildrenControls().get(2);
            TableWrapDataInfo layoutData = layout.getTableWrapData(filler);
            TableWrapLayoutTest.assertEquals((int)0, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "width"));
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "height"));
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_delete_replaceWithFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        shell.refresh();
        try {
            button.delete();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_delete_keepOneColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        try {
            button.delete();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_delete_removeEmptyDimensions() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(5);
        shell.refresh();
        try {
            TableWrapDataInfo layoutData = layout.getTableWrapData(button);
            TableWrapLayoutTest.assertEquals((int)1, (int)TableWrapLayoutTest.getInt(layoutData, "x"));
            TableWrapLayoutTest.assertEquals((int)2, (int)TableWrapLayoutTest.getInt(layoutData, "y"));
            button.delete();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_inEmptyCell() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_insertRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 1, true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_insertColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, true, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    new Label(this, SWT.LEFT);", "    new Label(this, SWT.RIGHT);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_insertColumnRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 0, true, 0, true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
            newButton.delete();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_appendRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 0, false, 2, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_appendColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 2, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_appendColumnRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 1, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_insertColumnHorizontalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 2);", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, true, 1, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 3));", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_insertRowVerticalSpan() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 2, 1);", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 1, true);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 3, 1));", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_notBalanced() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
        layout.command_CREATE(newButton, 1, false, 1, false);
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Shell_open() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      shell.setLayout(layout);", "    }", "    shell.open();", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 0, false);
            this.assertEditor("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      shell.setLayout(layout);", "    }", "    new Label(shell, SWT.NONE);", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setText('New Button');", "    }", "    shell.open();", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_Shell_layout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      shell.setLayout(layout);", "    }", "    shell.layout();", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 1, false, 0, false);
            this.assertEditor("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      shell.setLayout(layout);", "    }", "    new Label(shell, SWT.NONE);", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setText('New Button');", "    }", "    shell.layout();", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_columnAccess() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        final TableWrapColumnInfo column = (TableWrapColumnInfo)layout.getColumns().get(0);
        TableWrapLayoutTest.assertEquals((int)0, (int)column.getIndex());
        TableWrapLayoutTest.assertEquals((Object)"left", (Object)column.getTitle());
        TableWrapLayoutTest.assertFalse((boolean)column.getGrab());
        TableWrapLayoutTest.assertEquals((int)2, (int)column.getAlignment());
        column.flipGrab();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        TableWrapLayoutTest.assertEquals((Object)"left, grab", (Object)column.getTitle());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                column.setAlignment(128);
            }
        });
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        TableWrapLayoutTest.assertEquals((Object)"fill, grab", (Object)column.getTitle());
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        layout.getTableWrapData(button).setHorizontalAlignment(8);
        TableWrapLayoutTest.assertNull((Object)column.getAlignment());
        column.setAlignment(4);
        TableWrapLayoutTest.assertEquals((Object)"center, grab", (Object)column.getTitle());
        column.setAlignment(8);
        TableWrapLayoutTest.assertEquals((Object)"right, grab", (Object)column.getTitle());
        column.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
    }

    @Test
    public void test_rowAccess() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('1 x 1');", "    }", "  }", "}");
        shell.refresh();
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        final TableWrapRowInfo row = (TableWrapRowInfo)layout.getRows().get(1);
        TableWrapLayoutTest.assertEquals((int)1, (int)row.getIndex());
        TableWrapLayoutTest.assertEquals((Object)"top", (Object)row.getTitle());
        TableWrapLayoutTest.assertFalse((boolean)row.getGrab());
        TableWrapLayoutTest.assertEquals((int)16, (int)row.getAlignment());
        row.flipGrab();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('1 x 1');", "    }", "  }", "}");
        TableWrapLayoutTest.assertEquals((Object)"top, grab", (Object)row.getTitle());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                row.setAlignment(128);
            }
        });
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL_GRAB, 1, 1));", "      button.setText('0 x 1');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.LEFT, TableWrapData.FILL_GRAB, 1, 1));", "      button.setText('1 x 1');", "    }", "  }", "}");
        TableWrapLayoutTest.assertEquals((Object)"fill, grab", (Object)row.getTitle());
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        layout.getTableWrapData(button).setVerticalAlignment(64);
        TableWrapLayoutTest.assertNull((Object)row.getAlignment());
        row.setAlignment(16);
        TableWrapLayoutTest.assertEquals((Object)"top, grab", (Object)row.getTitle());
        row.setAlignment(32);
        TableWrapLayoutTest.assertEquals((Object)"middle, grab", (Object)row.getTitle());
        row.setAlignment(64);
        TableWrapLayoutTest.assertEquals((Object)"bottom, grab", (Object)row.getTitle());
        row.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('0 x 0');", "    }", "  }", "}");
    }

    @Test
    public void test_deleteColumn() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.colspan = 3;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                shell.startEdit();
                layout.command_deleteColumn(1, true);
            }
            finally {
                shell.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.colspan = 2;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_deleteColumn_deleteAlsoEmptyRows() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                shell.startEdit();
                layout.command_deleteColumn(1, true);
            }
            finally {
                shell.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_deleteRow() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.rowspan = 3;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('New Button');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                shell.startEdit();
                layout.command_deleteRow(1, true);
            }
            finally {
                shell.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.rowspan = 2;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_deleteRow_deleteAlsoEmptyColumns() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                shell.startEdit();
                layout.command_deleteRow(1, true);
            }
            finally {
                shell.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_COLUMN_before() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                layout.startEdit();
                layout.command_MOVE_COLUMN(1, 0);
            }
            finally {
                layout.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_COLUMN_after() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                layout.startEdit();
                layout.command_MOVE_COLUMN(0, 2);
            }
            finally {
                layout.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_ROW_before() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                layout.startEdit();
                layout.command_MOVE_ROW(1, 0);
            }
            finally {
                layout.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_ROW_after() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            try {
                layout.startEdit();
                layout.command_MOVE_ROW(0, 2);
            }
            finally {
                layout.endEdit();
            }
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(2);
        shell.refresh();
        try {
            layout.command_MOVE(button, 1, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('000');", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('111');", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('222');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_out() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        RowLayoutInfo layout = (RowLayoutInfo)composite.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        shell.refresh();
        try {
            layout.command_MOVE(button, null);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_error_1() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 4;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(7);
        shell.refresh();
        try {
            layout.command_MOVE(button, 1, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_MOVE_error_2() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 3;", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(5);
        shell.refresh();
        try {
            layout.command_MOVE(button, 0, false, 0, false);
            layout.getGridInfo();
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        shell.refresh();
        try {
            layout.command_ADD(button, 0, false, 1, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_noReference() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ControlInfo newButton = BTestUtils.createControl("org.eclipse.swt.widgets.Button");
            layout.command_CREATE(newButton, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_viewer() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        try {
            ViewerInfo viewer = ViewerTest.createTableViewer(this.m_lastEditor);
            TableInfo table = (TableInfo)JavaInfoUtils.getWrapped((JavaInfo)viewer);
            layout.command_CREATE((ControlInfo)table, 0, false, 0, false);
            this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);", "      Table table = tableViewer.getTable();", "      table.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB, 1, 1));", "    }", "  }", "}");
        }
        finally {
            shell.refresh_dispose();
        }
    }

    @Test
    public void test_DELETE_removeFillers() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    new Label(this, SWT.NONE);", "    new Button(this, SWT.NONE);", "  }", "}");
        TableWrapLayoutInfo layout = (TableWrapLayoutInfo)shell.getLayout();
        shell.refresh();
        TableWrapLayoutTest.assertEquals((int)2, (int)shell.getChildrenControls().size());
        layout.delete();
        TableWrapLayoutTest.assertEquals((int)1, (int)shell.getChildrenControls().size());
        this.assertEditor("class Test extends Shell {", "  Test() {", "    new Button(this, SWT.NONE);", "  }", "}");
    }

    @Test
    public void test_Switching_fromGridLayout() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(3, false));", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, true, false, 1, 1));", "      label.setText('New Label');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 2, 1));", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, true, 1, 1));", "      button.setText('New Button');", "    }", "  }", "}");
        composite.refresh();
        TableWrapLayoutInfo tableWrapLayout = (TableWrapLayoutInfo)BTestUtils.createLayout("org.eclipse.ui.forms.widgets.TableWrapLayout");
        composite.setLayout((LayoutInfo)tableWrapLayout);
        this.assertEditor("class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      TableWrapLayout tableWrapLayout = new TableWrapLayout();", "      tableWrapLayout.numColumns = 3;", "      setLayout(tableWrapLayout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.BOTTOM, 1, 1);", "        tableWrapData.grabHorizontal = true;", "        label.setLayoutData(tableWrapData);", "      }", "      label.setText('New Label');", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setLayoutData(new TableWrapData(TableWrapData.FILL, TableWrapData.TOP, 1, 2));", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP, 1, 1);", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "      button.setText('New Button');", "    }", "  }", "}");
    }

    private static int getInt(TableWrapDataInfo layoutData, String fieldName) throws Exception {
        return ReflectionUtils.getFieldInt((Object)layoutData, (String)fieldName);
    }
}

