/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.jdt.core;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.core.ZipFileFactory;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class ProjectUtilsTest
extends AbstractJavaTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            ProjectUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_hasNature() throws Exception {
        ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasNature((IProject)m_project, (String)"org.eclipse.jdt.core.javanature"));
        ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasNature((IProject)m_project, (String)"no.such.nature"));
    }

    @DisposeProjectAfter
    @Test
    public void test_addNature() throws Exception {
        TestUtils.addDynamicExtension2("org.eclipse.core.resources.natures", "MyTestNature", ProjectUtilsTest.getSourceDQ("<extension point='%pointId%' id='%extensionId%' name='My Test nature'>", "  <runtime>", "    <run class='" + MyNatureClass.class.getName() + "'/>", "  </runtime>", "</extension>"));
        try {
            ProjectUtilsTest.cleanUpNatureManager();
            ProjectUtils.addNature((IProject)m_testProject.getProject(), (String)"org.eclipse.wb.tests.MyTestNature");
        }
        finally {
            TestUtils.removeDynamicExtension("org.eclipse.core.resources.natures", "MyTestNature");
            ProjectUtilsTest.cleanUpNatureManager();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_removeNature() throws Exception {
        ProjectUtilsTest.assertTrue((boolean)m_project.hasNature("org.eclipse.jdt.core.javanature"));
        ProjectUtils.removeNature((IProject)m_project, (String)"org.eclipse.jdt.core.javanature");
        ProjectUtilsTest.assertFalse((boolean)m_project.hasNature("org.eclipse.jdt.core.javanature"));
    }

    private static void cleanUpNatureManager() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Object natureManager = ReflectionUtils.invokeMethod((Object)workspace, (String)"getNatureManager()", (Object[])new Object[0]);
        ReflectionUtils.setField((Object)natureManager, (String)"descriptors", null);
    }

    @Test
    public void test_getOptions() throws Exception {
        Map options = ProjectUtils.getOptions((IJavaProject)m_testProject.getJavaProject());
        ProjectUtilsTest.assertNotNull((Object)options);
        ProjectUtilsTest.assertEquals((Object)"error", options.get("org.eclipse.jdt.core.incompleteClasspath"));
    }

    @Test
    public void test_waitForAutoBuild() throws Exception {
        ProjectClassLoader classLoader = ProjectClassLoader.create(null, (IJavaProject)m_testProject.getJavaProject());
        ProjectUtilsTest.setFileContentSrc("test/Test.java", ProjectUtilsTest.getSource("// filler filler filler", "// filler filler filler", "public class Test {", "}"));
        try {
            classLoader.loadClass("test.Test");
            ProjectUtilsTest.fail();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ProjectUtils.waitForAutoBuild();
        classLoader.loadClass("test.Test");
    }

    @DisposeProjectAfter
    @Test
    public void test_ensureResourceType_existsButNotUpToDate() throws Exception {
        String managerClassName = "pkg.MyManager";
        String managerPath = "pkg/MyManager.java";
        ProjectUtilsTest.setFileContentSrc(managerPath, ProjectUtilsTest.getSource("package test;", "public class MyManager {", "  // old version", "  // filler filler filler", "}"));
        ProjectUtilsTest.assertNotNull((Object)m_javaProject.findType(managerClassName));
        TestBundle testBundle = new TestBundle();
        try {
            String managerSource = ProjectUtilsTest.getSource("package test;", "public class MyManager {", "  // recent version", "  // filler filler filler", "}");
            testBundle.setFile("resources/1.8/pkg/MyManager.java", managerSource);
            testBundle.install();
            ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)managerClassName);
            ProjectUtilsTest.assertTrue((m_javaProject.findType(managerClassName) != null ? 1 : 0) != 0);
            ProjectUtilsTest.assertEquals((Object)managerSource, (Object)ProjectUtilsTest.getFileContentSrc(managerPath));
            IFile managerFile = ProjectUtilsTest.getFileSrc(managerPath);
            long managerStamp = managerFile.getModificationStamp();
            ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)managerClassName);
            ProjectUtilsTest.assertTrue((m_javaProject.findType(managerClassName) != null ? 1 : 0) != 0);
            ProjectUtilsTest.assertEquals((long)managerStamp, (long)managerFile.getModificationStamp());
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_ensureResourceType_existsInDifferentProject_butNotUpToDate() throws Exception {
        String managerClassName = "pkg.MyManager";
        String managerPath = "pkg/MyManager.java";
        TestProject myProjectHelper = new TestProject("myProject");
        IProject myProject = myProjectHelper.getProject();
        m_testProject.addRequiredProject(myProject);
        ProjectUtilsTest.setFileContentSrc(myProject, managerPath, ProjectUtilsTest.getSource("package pkg;", "public class MyManager {", "  // old version", "  // filler filler filler", "}"));
        IType type = m_javaProject.findType(managerClassName);
        ProjectUtilsTest.assertNotNull((Object)type);
        IPath fullPath = type.getUnderlyingResource().getFullPath();
        Assertions.assertThat((String)fullPath.toPortableString()).contains(new CharSequence[]{"/myProject/src/"});
        ProjectUtilsTest.assertFalse((boolean)ProjectUtilsTest.getFileSrc(managerPath).exists());
        TestBundle testBundle = new TestBundle();
        try {
            String managerSource = ProjectUtilsTest.getSource("package pkg;", "public class MyManager {", "  // recent version", "  // filler filler filler", "}");
            testBundle.setFile("resources/1.8/pkg/MyManager.java", managerSource);
            testBundle.install();
            ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)managerClassName);
            ProjectUtilsTest.assertNotNull((Object)m_javaProject.findType(managerClassName));
            ProjectUtilsTest.assertFalse((boolean)ProjectUtilsTest.getFileSrc(managerPath).exists());
            ProjectUtilsTest.assertEquals((Object)managerSource, (Object)ProjectUtilsTest.getFileContentSrc(myProject, managerPath));
        }
        finally {
            testBundle.dispose();
            myProjectHelper.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_ensureResourceType_binary() throws Exception {
        String managerClassName = "pkg.MyManager";
        String managerPath = "pkg/MyManager.java";
        String managerSourceOld = ProjectUtilsTest.getSource("package pkg;", "public class MyManager {", "  // old version, in binary", "  // filler filler filler", "}");
        ProjectUtilsTest.setFileContentSrc(managerPath, managerSourceOld);
        ProjectUtilsTest.waitForAutoBuild();
        File managerJar = File.createTempFile("Manager", ".jar");
        ZipFileFactory factory = new ZipFileFactory(new FileOutputStream(managerJar));
        factory.add("pkg/MyManager.class", ProjectUtilsTest.getFile("bin/pkg/MyManager.class").getContents());
        factory.close();
        IType type = m_javaProject.findType(managerClassName);
        type.getCompilationUnit().delete(true, null);
        ProjectUtilsTest.assertNull((Object)m_javaProject.findType(managerClassName));
        TestBundle testBundle = new TestBundle();
        try {
            String managerSourceNew = ProjectUtilsTest.getSource("package test;", "public class MyManager {", "  // recent version", "  // filler filler filler", "  public int newField;", "}");
            testBundle.setFile("resources/1.8/pkg/MyManager.java", managerSourceNew);
            testBundle.install();
            m_testProject.addExternalJar(managerJar);
            IType managerType = m_javaProject.findType(managerClassName);
            ProjectUtilsTest.assertNotNull((Object)managerType);
            Assertions.assertThat((Object[])managerType.getFields()).isEmpty();
            ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)managerClassName);
            managerType = m_javaProject.findType(managerClassName);
            ProjectUtilsTest.assertNotNull((Object)managerType);
            Assertions.assertThat((Object[])managerType.getFields()).isEmpty();
        }
        finally {
            testBundle.dispose();
            managerJar.delete();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_ensureResourceType_readOnly() throws Exception {
        String managerClassName = "pkg.MyManager";
        String managerPath = "pkg/MyManager.java";
        String oldSource = ProjectUtilsTest.getSource("package pkg;", "public class MyManager {", "  // old version", "  // filler filler filler filler filler", "}");
        IFile managerFile = ProjectUtilsTest.setFileContentSrc(managerPath, oldSource);
        ResourceAttributes resourceAttributes = managerFile.getResourceAttributes();
        resourceAttributes.setReadOnly(true);
        managerFile.setResourceAttributes(resourceAttributes);
        ProjectUtilsTest.assertNotNull((Object)m_javaProject.findType(managerClassName));
        TestBundle testBundle = new TestBundle();
        try {
            String newSource = ProjectUtilsTest.getSource("package pkg;", "public class MyManager {", "  // recent version", "  // filler filler filler filler filler", "}");
            testBundle.setFile("resources/1.8/pkg/MyManager.java", newSource);
            testBundle.install();
            ProjectUtils.ensureResourceType((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)managerClassName);
            ProjectUtilsTest.assertTrue((m_javaProject.findType(managerClassName) != null ? 1 : 0) != 0);
            ProjectUtilsTest.assertEquals((Object)oldSource, (Object)ProjectUtilsTest.getFileContentSrc(managerPath));
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_hasType() throws Exception {
        ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"java.lang.String"));
        ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"aaa.bbb.ccc.Test"));
        ProjectUtilsTest.setFileContentSrc("aaa/bbb/ccc/Test.java", ProjectUtilsTest.getSource("package aaa.bbb.ccc;", "import javax.swing.JFrame;", "public class Test extends JFrame {", "}"));
        ProjectUtilsTest.waitForAutoBuild();
        ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"aaa.bbb.ccc.Test"));
    }

    @DisposeProjectAfter
    @Test
    public void test_addJar_usingPaths() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("resources/myClasses.zip").add("A.java", "AaA").close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            Bundle bundle = testBundle.getBundle();
            String jarPath = FileLocator.toFileURL((URL)bundle.getEntry("/resources/myClasses.jar")).getPath();
            String srcPath = FileLocator.toFileURL((URL)bundle.getEntry("/resources/myClasses.zip")).getPath();
            ProjectUtils.addJar((IJavaProject)m_javaProject, (String)jarPath, (String)srcPath);
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtilsTest.assertFileExists("myClasses.zip");
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addJar_fromBundle() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("resources/myClasses.zip").add("A.java", "AaA").close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtils.addJar((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)"resources/myClasses.jar", (String)"resources/myClasses.zip");
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtilsTest.assertFileExists("myClasses.zip");
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addJar_fromBundle_noSrc() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtils.addJar((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)"resources/myClasses.jar", null);
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtilsTest.assertFileNotExists("myClasses.zip");
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addJar_whenPDE() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null);
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtils.addJar((IJavaProject)m_javaProject, (Bundle)testBundle.getBundle(), (String)"resources/myClasses.jar", null);
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            String manifest = ProjectUtilsTest.getFileContent("META-INF/MANIFEST.MF");
            Assertions.assertThat((String)manifest).contains(new CharSequence[]{"Bundle-ClassPath: .,\n myClasses.jar\n"});
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addExternalJar() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            Bundle bundle = testBundle.getBundle();
            URL jarEntry = bundle.getEntry("/resources/myClasses.jar");
            String jarPath = FileLocator.toFileURL((URL)jarEntry).getPath();
            ProjectUtils.addExternalJar((IJavaProject)m_javaProject, (String)jarPath, null);
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            ProjectUtilsTest.assertFalse((boolean)m_project.getFile("myClasses.jar").exists());
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addClasspathEntry() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("resources/myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.install();
            ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
            Bundle bundle = testBundle.getBundle();
            URL jarEntry = bundle.getEntry("/resources/myClasses.jar");
            String jarPath = FileLocator.toFileURL((URL)jarEntry).getPath();
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null);
            ProjectUtils.addClasspathEntry((IJavaProject)m_javaProject, (IClasspathEntry)entry);
            ProjectUtilsTest.waitForAutoBuild();
            ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)className));
        }
        finally {
            testBundle.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_addPluginLibraries() throws Exception {
        ProjectUtilsTest.assertFalse((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"org.eclipse.jdt.core.IType"));
        ProjectUtils.addPluginLibraries((IJavaProject)m_javaProject, (String)"org.eclipse.jdt.core");
        ProjectUtilsTest.assertTrue((boolean)ProjectUtils.hasType((IJavaProject)m_javaProject, (String)"org.eclipse.jdt.core.IType"));
    }

    @DisposeProjectAfter
    @Test
    public void test_removeClasspathEntries() throws Exception {
        Object[] rawClasspath = m_javaProject.getRawClasspath();
        Assertions.assertThat((Object[])rawClasspath).hasSize(2);
        ProjectUtilsTest.assertEquals((Object)"org.eclipse.jdt.launching.JRE_CONTAINER", (Object)rawClasspath[0].getPath().toPortableString());
        ProjectUtilsTest.assertEquals((Object)"/TestProject/src", (Object)rawClasspath[1].getPath().toPortableString());
        ProjectUtils.removeClasspathEntries((IJavaProject)m_javaProject, entry -> {
            String location = entry.getPath().toPortableString();
            return location.endsWith("/src");
        });
        rawClasspath = m_javaProject.getRawClasspath();
        Assertions.assertThat((Object[])rawClasspath).hasSize(1);
        ProjectUtilsTest.assertEquals((Object)"org.eclipse.jdt.launching.JRE_CONTAINER", (Object)rawClasspath[0].getPath().toPortableString());
    }

    @Test
    public void test_getOSPath_noSuchPath() throws Exception {
        Path workspacePath = new Path("/noSuchProject/andNoFolder");
        IPath osPath = ProjectUtils.getOSPath((IPath)workspacePath);
        ProjectUtilsTest.assertNull((Object)osPath);
    }

    @Test
    public void test_getOSPath_forSourceFolder() throws Exception {
        this.assert_test_getOSPath("/TestProject/src", "TestProject/src");
    }

    @Test
    public void test_getOSPath_forOutputFolder() throws Exception {
        this.assert_test_getOSPath("/TestProject/bin", "TestProject/bin");
    }

    @Test
    public void test_getOSPath_forProjectItself() throws Exception {
        this.assert_test_getOSPath("/TestProject", "TestProject");
    }

    private void assert_test_getOSPath(String workspacePathString, String expectedLocation) {
        Path workspacePath = new Path(workspacePathString);
        IPath osPath = ProjectUtils.getOSPath((IPath)workspacePath);
        String osLocation = osPath.toPortableString();
        String pathEnds = null;
        pathEnds = "org.eclipse.pde.junit.runtime.uitestapplication".equals(System.getProperty("eclipse.application")) ? Expectations.get("junit-workspace/" + expectedLocation, new Expectations.StrValue("scheglov-macpro", "/" + expectedLocation), new Expectations.StrValue("sablin-aa", ".wbp-tt/Core/" + expectedLocation), new Expectations.StrValue("flanker-windows", "-Core.TWS/" + expectedLocation), new Expectations.StrValue("flanker-desktop", ".wbp-tt/Core/" + expectedLocation)) : Expectations.get("target/work/data/" + expectedLocation, new Expectations.StrValue[0]);
        Assertions.assertThat((String)osLocation).endsWith((CharSequence)pathEnds);
    }

    @Test
    public void test_findFiles_oneProject() throws Exception {
        IFile file = ProjectUtilsTest.setFileContent("folder/1.txt", "");
        List files = ProjectUtils.findFiles((IJavaProject)m_testProject.getJavaProject(), (String)"folder/1.txt");
        Assertions.assertThat((List)files).containsOnly((Object[])new IFile[]{file});
    }

    @DisposeProjectAfter
    @Test
    public void test_findFiles_twoProjects() throws Exception {
        TestProject myProject = new TestProject("myProject");
        try {
            ProjectUtils.requireProject((IJavaProject)m_testProject.getJavaProject(), (IJavaProject)myProject.getJavaProject());
            IFile file_1 = ProjectUtilsTest.setFileContent(m_testProject.getProject(), "folder/1.txt", "");
            IFile file_2 = ProjectUtilsTest.setFileContent(myProject.getProject(), "folder/1.txt", "");
            List files = ProjectUtils.findFiles((IJavaProject)m_testProject.getJavaProject(), (String)"folder/1.txt");
            Assertions.assertThat((List)files).containsOnly((Object[])new IFile[]{file_1, file_2});
        }
        finally {
            myProject.dispose();
        }
    }

    @DisposeProjectAfter
    @Test
    public void test_findFiles_notExistingProject() throws Exception {
        TestProject myProject = new TestProject("myProject");
        m_testProject.addRequiredProject(myProject);
        myProject.dispose();
        IFile file = ProjectUtilsTest.setFileContent(m_testProject.getProject(), "folder/1.txt", "");
        List files = ProjectUtils.findFiles((IJavaProject)m_testProject.getJavaProject(), (String)"folder/1.txt");
        Assertions.assertThat((List)files).containsOnly((Object[])new IFile[]{file});
    }

    public static class ClassForBundle {
    }

    public static class MyNatureClass
    implements IProjectNature {
        public IProject getProject() {
            return null;
        }

        public void setProject(IProject project) {
        }

        public void configure() throws CoreException {
        }

        public void deconfigure() throws CoreException {
        }
    }
}

