/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.factory.FactoryApplyAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class FactoryApplyActionTest
extends SwingModelTest {
    private static final String ICON_PATH = "/javax/swing/plaf/basic/icons/JavaCup16.png";

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noParameters() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton()");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton();", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_noBoundProperty() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source myText 'text'", "  */", "  public static JButton createButton(String myText) {", "    return new JButton(myText);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('text');", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_singleBoundProperty_noValue() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('text');", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_singleBoundProperty() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText('my text');", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /button.setText('my text')/ /add(button)/}");
        ComponentInfo button = (ComponentInfo)FactoryApplyActionTest.getJavaInfoByName("button");
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('my text');", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {static factory: test.StaticFactory createButton(java.lang.String)} {local-unique: button} {/add(button)/ /StaticFactory.createButton('my text')/}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_twoBoundProperty() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  * @wbp.factory.parameter.source icon null", "  */", "  public static JButton createButton(String text, Icon icon) {", "    return new JButton(text, icon);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText('my text');", "    button.setIcon(new ImageIcon(getClass().getResource('/javax/swing/plaf/basic/icons/JavaCup16.png')));", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String,javax.swing.Icon)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('my text', null);", "    button.setIcon(new ImageIcon(getClass().getResource('/javax/swing/plaf/basic/icons/JavaCup16.png')));", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_boundToOldConstuctorArgument() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('my text');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('my text');", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_withParent() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container, String text) {", "    setText(text);", "    container.add(this);", "  }", "}"));
        FactoryApplyActionTest.setFileContentSrc("test/MyButton.wbp-component.xml", FactoryApplyActionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "      <parameter type='java.lang.String' property='setText(java.lang.String)'/>", "    </constructor>", "  </constructors>", "</component>"));
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  */", "  public static MyButton createButton(Container parent, String text) {", "    return new MyButton(parent, text);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton(this, 'my text');", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ConstructorParentAssociation association = (ConstructorParentAssociation)button.getAssociation();
        FactoryApplyActionTest.assertEquals((Object)"new MyButton(this, \"my text\")", (Object)association.getSource());
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.awt.Container,java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = StaticFactory.createButton(this, 'my text');", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        association = (FactoryParentAssociation)button.getAssociation();
        FactoryApplyActionTest.assertEquals((Object)"StaticFactory.createButton(this, \"my text\")", (Object)association.getSource());
    }

    @Test
    public void test_boundPropertyVariable() throws Exception {
        FactoryApplyActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'text'", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryApplyActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    String theText = 'my text';", "    button.setText(theText);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryApplyActionTest.doApply((JavaInfo)button, "createButton(java.lang.String)");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton('text');", "    String theText = 'my text';", "    button.setText(theText);", "    add(button);", "  }", "}");
        FactoryApplyActionTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)button.getCreationSupport());
        FactoryApplyActionTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
    }

    private static void doApply(JavaInfo component, String methodSignature) throws Exception {
        AstEditor editor = component.getEditor();
        Class<?> factoryClass = EditorState.get((AstEditor)editor).getEditorLoader().loadClass("test.StaticFactory");
        FactoryMethodDescription factoryDescription = FactoryDescriptionHelper.getDescription((AstEditor)editor, factoryClass, (String)methodSignature, (boolean)true);
        FactoryApplyActionTest.assertNotNull((Object)factoryDescription, (String)("No factory method with signature: " + methodSignature));
        FactoryApplyAction action = new FactoryApplyAction(component, factoryDescription);
        action.run();
    }
}

