/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import org.eclipse.wb.internal.core.model.creation.SuperInvocationCreationSupport;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class SuperInvocationCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_access() throws Exception {
        this.prepareMyPanel();
        this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = super.getMyButton();", "    add(button);", "  }", "}");
        SuperInvocationCreationSupportTest.assertHierarchy("{this: test.MyPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {superInvocation: super.getMyButton()} {local-unique: button} {/super.getMyButton()/ /add(button)/}");
        ComponentInfo button = (ComponentInfo)SuperInvocationCreationSupportTest.getJavaInfoByName("button");
        SuperInvocationCreationSupport creationSupport = (SuperInvocationCreationSupport)button.getCreationSupport();
        SuperInvocationCreationSupportTest.assertEquals((Object)"super.getMyButton()", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        SuperInvocationCreationSupportTest.assertEquals((Object)"superInvocation: super.getMyButton()", (Object)creationSupport.toString());
        SuperInvocationCreationSupportTest.assertTrue((boolean)creationSupport.isJavaInfo(creationSupport.getNode()));
        SuperInvocationCreationSupportTest.assertFalse((boolean)creationSupport.isJavaInfo(null));
        SuperInvocationCreationSupportTest.assertTrue((boolean)creationSupport.canReorder());
        SuperInvocationCreationSupportTest.assertTrue((boolean)creationSupport.canReparent());
    }

    @Test
    public void test_delete() throws Exception {
        this.prepareMyPanel();
        this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = super.getMyButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)SuperInvocationCreationSupportTest.getJavaInfoByName("button");
        SuperInvocationCreationSupportTest.assertTrue((boolean)button.canDelete());
        SuperInvocationCreationSupportTest.assertTrue((boolean)button.getCreationSupport().canDelete());
        button.delete();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareMyPanel() throws Exception {
        SuperInvocationCreationSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton myButton = new JButton();", "  public JButton getMyButton() {", "    return myButton;", "  }", "}"));
        SuperInvocationCreationSupportTest.waitForAutoBuild();
    }
}

