/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.model.presentation;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;

public abstract class JavaInfoDecorator {
    public static final ImageDescriptor IMAGE_DESCRIPTOR = Activator.getImageDescriptor("decorator.gif");
    private final IDatabindingsProvider m_provider;

    public JavaInfoDecorator(IDatabindingsProvider provider, ObjectInfo objectInfoRoot) {
        this.m_provider = provider;
        objectInfoRoot.addBroadcastListener((Object)new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, ImageDescriptor[] icon) throws Exception {
                if (JavaInfoDecorator.this.hasDecorate(object)) {
                    icon[0] = new DecorationOverlayIcon(icon[0], IMAGE_DESCRIPTOR, 1);
                }
            }
        });
    }

    private boolean hasDecorate(ObjectInfo object) throws Exception {
        String objectReference;
        if (!this.m_provider.getBindings().isEmpty() && this.accept(object) && (objectReference = this.getReference(object)) != null) {
            for (IBindingInfo binding : this.m_provider.getBindings()) {
                if (!this.equals(object, objectReference, binding.getTarget()) && !this.equals(object, objectReference, binding.getModel())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean accept(ObjectInfo var1) throws Exception;

    protected abstract String getReference(ObjectInfo var1) throws Exception;

    protected abstract boolean equals(ObjectInfo var1, String var2, IObserveInfo var3) throws Exception;
}

