/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.utils;

import java.io.Closeable;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.draw2d.FigureCanvas;

public class AutoScroller
implements Closeable {
    private final Point location;
    private RangeModel m_horizontalRange;
    private RangeModel m_verticalRange;

    public AutoScroller(EditPartViewer viewer, int x, int y) {
        Control control = viewer.getControl();
        if (control instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            Viewport viewport = canvas.getViewport();
            this.m_horizontalRange = viewport.getHorizontalRangeModel();
            this.m_verticalRange = viewport.getVerticalRangeModel();
            int offX = Math.max(x - this.m_horizontalRange.getExtent() + 8, 0);
            int offY = Math.max(y - this.m_verticalRange.getExtent() + 8, 0);
            this.m_horizontalRange.setValue(offX);
            this.m_verticalRange.setValue(offY);
            int scrolledX = x - this.m_horizontalRange.getValue();
            int scrolledY = y - this.m_verticalRange.getValue();
            this.location = new Point(scrolledX, scrolledY);
        } else {
            this.location = new Point(x, y);
        }
    }

    public Point getLocation() {
        return this.location;
    }

    @Override
    public void close() {
        if (this.m_horizontalRange != null) {
            this.m_horizontalRange.setValue(0);
        }
        if (this.m_verticalRange != null) {
            this.m_verticalRange.setValue(0);
        }
    }
}

