/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.core.tools.DragEditPartTracker;
import org.eclipse.wb.gef.core.tools.SelectEditPartTracker;
import org.eclipse.wb.tests.gef.RequestTestCase;
import org.eclipse.wb.tests.gef.RequestTestCaseEditPart;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.junit.jupiter.api.Test;

public class SelectAndDragEditPartTrackerTest
extends RequestTestCase {
    @Test
    public void test_Selection() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart1 = new RequestTestCaseEditPart("editPart1", actualLogger);
        editPart1.activate();
        RequestTestCaseEditPart editPart2 = new RequestTestCaseEditPart("editPart2", actualLogger);
        editPart2.activate();
        RequestTestCaseEditPart editPart3 = new RequestTestCaseEditPart("editPart3", actualLogger);
        editPart3.activate();
        RequestTestCaseEditPart editPart4 = new RequestTestCaseEditPart("editPart4", actualLogger);
        editPart4.activate();
        RequestTestCaseEditPart editPart5 = new RequestTestCaseEditPart("editPart5", actualLogger);
        editPart5.activate();
        SelectEditPartTracker tracker = new SelectEditPartTracker((EditPart)editPart1);
        this.m_domain.setActiveTool((Tool)tracker);
        SelectAndDragEditPartTrackerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        SelectAndDragEditPartTrackerTest.assertEquals((int)0, (int)editPart1.getSelected());
        this.m_sender.click(0, 0, 4);
        SelectAndDragEditPartTrackerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        SelectAndDragEditPartTrackerTest.assertEquals((int)0, (int)editPart1.getSelected());
        actualLogger.assertEmpty();
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.click(0, 0, 1);
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart1), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)editPart1.getSelected());
        actualLogger.assertEmpty();
        tracker = new SelectEditPartTracker((EditPart)editPart2);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.click(0, 0, 3);
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart2), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)editPart2.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)0, (int)editPart1.getSelected());
        actualLogger.assertEmpty();
        tracker = new SelectEditPartTracker((EditPart)editPart3);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.setStateMask(131072);
        this.m_sender.click(0, 0, 1);
        this.m_sender.setStateMask(0);
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart2), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart3), this.m_viewer.getSelectedEditParts().get(1));
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)editPart2.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)editPart3.getSelected());
        actualLogger.assertEmpty();
        tracker = new SelectEditPartTracker((EditPart)editPart4);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.setStateMask(262144);
        this.m_sender.click(0, 0, 1);
        this.m_sender.setStateMask(0);
        SelectAndDragEditPartTrackerTest.assertEquals((int)3, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart2), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart3), this.m_viewer.getSelectedEditParts().get(1));
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart4), this.m_viewer.getSelectedEditParts().get(2));
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)editPart2.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)editPart3.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)editPart4.getSelected());
        actualLogger.assertEmpty();
        tracker = new SelectEditPartTracker((EditPart)editPart2);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.setStateMask(262144);
        this.m_sender.click(0, 0, 1);
        this.m_sender.setStateMask(0);
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart3), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)editPart4), this.m_viewer.getSelectedEditParts().get(1));
        SelectAndDragEditPartTrackerTest.assertEquals((int)0, (int)editPart2.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)editPart3.getSelected());
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)editPart4.getSelected());
        actualLogger.assertEmpty();
        tracker = new SelectEditPartTracker((EditPart)editPart5);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.doubleClick(1, 1, 1);
        RequestsLogger expectedLogger = new RequestsLogger();
        SelectionRequest request = new SelectionRequest();
        request.setType((Object)"open");
        request.setLocation(new Point(1, 1));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart5, "performRequest", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Drag_1() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart2", actualLogger, 250, 25, 100, 155);
        RequestsLogger expectedLogger = new RequestsLogger();
        DragEditPartTracker tracker = new DragEditPartTracker((EditPart)childEditPart1);
        this.m_domain.setActiveTool((Tool)tracker);
        SelectAndDragEditPartTrackerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        this.m_sender.startDrag(120, 120, 1);
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)childEditPart1.getSelected());
        actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "performRequest", (Request)new DragPermissionRequest());
        request.setLocation(new Point(130, 120));
        request.setMoveDelta(new Point(10, 0));
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(140, 120);
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        request.setLocation(new Point(140, 120));
        request.setMoveDelta(new Point(20, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(330, 120);
        request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        request.setLocation(new Point(330, 120));
        request.setMoveDelta(new Point(210, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        request.setType((Object)"add children");
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, new String[]{"showTargetFeedback", "showTargetFeedback"}, (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "getCommand", (Request)new GroupRequest((Object)"orphan"));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "getCommand", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        request.setLocation(new Point(330, 120));
        request.setMoveDelta(new Point(210, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "eraseTargetFeedback", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.startDrag(120, 120, 1);
        this.m_sender.dragTo(140, 120);
        this.m_sender.endDrag();
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Drag_2() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = new RequestTestCaseEditPart("ChildEditPart1", actualLogger){

            @Override
            public void performRequest(Request request) {
                if (request instanceof DragPermissionRequest) {
                    DragPermissionRequest permissionRequest = (DragPermissionRequest)request;
                    permissionRequest.setMove(false);
                    permissionRequest.setReparent(false);
                }
                super.performRequest(request);
            }
        };
        editPart.getFigure().setBounds(new Rectangle(50, 50, 70, 50));
        SelectAndDragEditPartTrackerTest.addChildEditPart((org.eclipse.gef.EditPart)editPart, (org.eclipse.gef.EditPart)childEditPart1);
        SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart2", actualLogger, 250, 25, 100, 155);
        RequestsLogger expectedLogger = new RequestsLogger();
        DragEditPartTracker tracker = new DragEditPartTracker((EditPart)childEditPart1);
        this.m_domain.setActiveTool((Tool)tracker);
        SelectAndDragEditPartTrackerTest.assertTrue((boolean)this.m_viewer.getSelectedEditParts().isEmpty());
        this.m_sender.startDrag(120, 120, 1);
        SelectAndDragEditPartTrackerTest.assertEquals((int)1, (int)this.m_viewer.getSelectedEditParts().size());
        SelectAndDragEditPartTrackerTest.assertSame((Object)((Object)childEditPart1), this.m_viewer.getSelectedEditParts().get(0));
        SelectAndDragEditPartTrackerTest.assertEquals((int)2, (int)childEditPart1.getSelected());
        actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        DragPermissionRequest permissionRequest = new DragPermissionRequest();
        permissionRequest.setMove(false);
        permissionRequest.setReparent(false);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "performRequest", (Request)permissionRequest);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(140, 120);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(330, 120);
        actualLogger.assertEmpty();
        this.m_sender.endDrag();
        actualLogger.assertEmpty();
        this.m_sender.startDrag(120, 120, 1);
        this.m_sender.dragTo(140, 120);
        this.m_sender.endDrag();
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Drag_InvalidInput() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart", actualLogger, 50, 50, 70, 50);
        RequestsLogger expectedLogger = new RequestsLogger();
        DragEditPartTracker tracker = new DragEditPartTracker((EditPart)childEditPart);
        this.m_domain.setActiveTool((Tool)tracker);
        this.m_sender.startDrag(120, 120, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart, "performRequest", (Request)new DragPermissionRequest());
        request.setLocation(new Point(130, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.click(131, 121, 3);
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart);
        request.setLocation(new Point(130, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.dragTo(140, 120);
        actualLogger.assertEmpty();
        this.m_sender.endDrag();
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Drag_AncestorSelection() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)childEditPart1, "ChildEditPart2", actualLogger, 10, 10, 50, 30);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart1);
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart2);
        this.m_domain.setActiveTool((Tool)new DragEditPartTracker((EditPart)childEditPart1));
        this.m_sender.startDrag(120, 120, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(130, 120);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "performRequest", (Request)new DragPermissionRequest());
        request.setLocation(new Point(130, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts((org.eclipse.gef.EditPart)childEditPart1);
        request.setLocation(new Point(130, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
    }

    @Test
    public void test_Drag_WrongSelection() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)childEditPart1, "ChildEditPart2", actualLogger, 10, 10, 50, 30);
        RequestTestCaseEditPart childEditPart3 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart3", actualLogger, 250, 50, 70, 50);
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart2);
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart3);
        this.m_domain.setActiveTool((Tool)new DragEditPartTracker((EditPart)childEditPart3));
        this.m_sender.startDrag(310, 120, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(320, 120);
        actualLogger.assertEmpty();
        this.m_sender.endDrag();
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Drag_MultiSelection() throws Exception {
        RequestsLogger actualLogger = new RequestsLogger();
        RequestTestCaseEditPart editPart = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)this.m_viewer.getRootEditPart(), "ParentEditPart", actualLogger, 50, 50, 400, 300);
        RequestTestCaseEditPart childEditPart1 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart1", actualLogger, 50, 50, 70, 50);
        RequestTestCaseEditPart childEditPart2 = SelectAndDragEditPartTrackerTest.addEditPart((EditPart)editPart, "ChildEditPart2", actualLogger, 250, 50, 70, 50);
        RequestsLogger expectedLogger = new RequestsLogger();
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart1);
        this.m_viewer.appendSelection((org.eclipse.gef.EditPart)childEditPart2);
        this.m_domain.setActiveTool((Tool)new DragEditPartTracker((EditPart)childEditPart2));
        this.m_sender.startDrag(310, 120, 1);
        actualLogger.assertEmpty();
        this.m_sender.dragTo(320, 120);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts(List.of(childEditPart1, childEditPart2));
        DragPermissionRequest permissionRequest = new DragPermissionRequest();
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart1, "performRequest", (Request)permissionRequest);
        expectedLogger.log((org.eclipse.gef.EditPart)childEditPart2, "performRequest", (Request)permissionRequest);
        request.setLocation(new Point(320, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart"}, (Request)request);
        request.setType((Object)"move");
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "showTargetFeedback", (Request)request);
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, new String[]{"getTargetEditPart", "getTargetEditPart", "showTargetFeedback", "getCommand"}, (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
        this.m_sender.endDrag();
        request = new ChangeBoundsRequest((Object)"move");
        request.setEditParts(List.of(childEditPart1, childEditPart2));
        request.setLocation(new Point(320, 120));
        request.setMoveDelta(new Point(10, 0));
        expectedLogger.log((org.eclipse.gef.EditPart)editPart, "eraseTargetFeedback", (Request)request);
        SelectAndDragEditPartTrackerTest.assertLoggers(expectedLogger, actualLogger);
    }
}

