/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.swing2swt;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.swing2swt.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.swing2swt.AbstractSwing2SwtTest;
import org.junit.jupiter.api.Test;

public class BorderLayoutTest
extends AbstractSwing2SwtTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}");
        shell.refresh();
        BorderLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new BorderLayout(0, 0))/}", "  {new: swing2swt.layout.BorderLayout} {empty} {/setLayout(new BorderLayout(0, 0))/}");
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        Assertions.assertThat((List)new FlowContainerFactory((JavaInfo)layout, true).get()).isEmpty();
        Assertions.assertThat((List)new FlowContainerFactory((JavaInfo)layout, false).get()).isNotEmpty();
    }

    @Test
    public void test_getControl() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(BorderLayout.NORTH);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(BorderLayout.WEST);", "    }", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        BorderLayoutTest.assertSame((Object)button_1, (Object)layout.getControl("NORTH"));
        BorderLayoutTest.assertSame((Object)button_2, (Object)layout.getControl("WEST"));
        BorderLayoutTest.assertSame(null, (Object)layout.getControl("SOUTH"));
        BorderLayoutTest.assertSame(null, (Object)layout.getControl("EAST"));
        BorderLayoutTest.assertSame(null, (Object)layout.getControl("CENTER"));
    }

    @Test
    public void test_whenLayoutDelete_setLayoutData() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(BorderLayout.NORTH);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(BorderLayout.WEST);", "    }", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        layout.delete();
        this.assertEditor("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        ControlInfo newButton = BTestUtils.createButton();
        layout.command_CREATE(newButton, "NORTH");
        this.assertEditor("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_setRegion() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(BorderLayout.NORTH);", "    }", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        layout.command_MOVE(button, "WEST");
        this.assertEditor("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(BorderLayout.WEST);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_withReparent() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(BorderLayout.NORTH);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(1);
        ControlInfo button_2 = (ControlInfo)composite.getChildrenControls().get(0);
        layout.command_MOVE(button_2, "WEST");
        this.assertEditor("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(BorderLayout.NORTH);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setLayoutData(BorderLayout.WEST);", "    }", "  }", "}");
    }

    @Test
    public void test_RegionProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(BorderLayout.NORTH);", "    }", "  }", "}");
        shell.refresh();
        BorderLayoutInfo layout = (BorderLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Property property = button.getPropertyByTitle("Region");
        BorderLayoutTest.assertSame((Object)property, (Object)button.getPropertyByTitle("Region"));
        BorderLayoutTest.assertTrue((boolean)property.isModified());
        BorderLayoutTest.assertEquals((Object)"North", (Object)property.getValue());
        property.setValue((Object)"West");
        layout.command_MOVE(button, "WEST");
        this.assertEditor("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(BorderLayout.WEST);", "    }", "  }", "}");
    }

    @Test
    public void test_RegionProperty_noValue() throws Exception {
        CompositeInfo shell = this.parseComposite("import swing2swt.layout.BorderLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        Property property = button_2.getPropertyByTitle("Region");
        BorderLayoutTest.assertTrue((boolean)property.isModified());
        BorderLayoutTest.assertEquals((Object)"Center", (Object)property.getValue());
        property = button_1.getPropertyByTitle("Region");
        BorderLayoutTest.assertTrue((boolean)property.isModified());
        BorderLayoutTest.assertEquals((Object)"", (Object)property.getValue());
    }
}

