/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.validator;

import org.eclipse.wb.core.gef.policy.validator.CompatibleLayoutRequestValidator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.editor.validator.AbstractLayoutRequestValidatorTest;
import org.junit.jupiter.api.Test;

public class CompatibleLayoutRequestValidatorTest
extends AbstractLayoutRequestValidatorTest {
    private static final ILayoutRequestValidator validator = CompatibleLayoutRequestValidator.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_notJavaInfo() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object parent = new Object();
        Object child = new Object();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, parent, child);
    }

    @Test
    public void test_noChecks() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createJButton();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, (Object)button);
    }

    @Test
    public void test_childNotJavaInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object child = new Object();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, child);
    }

    @Test
    public void test_parentNotJavaInfo() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object parent = new Object();
        ComponentInfo child = CompatibleLayoutRequestValidatorTest.createJButton();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, parent, (Object)child);
    }

    @Test
    public void test_parentScript_alwaysTrue() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"GEF.requestValidator.parent", (String)"true");
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createJButton();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, (Object)button);
    }

    @Test
    public void test_parentScript_alwaysFalse() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"GEF.requestValidator.parent", (String)"false");
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createJButton();
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, false, panel, (Object)button);
    }

    @Test
    public void test_parentScript_acceptOnlyJButton() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"GEF.requestValidator.parent", (String)"isComponentType(child, 'javax.swing.JButton')");
        ComponentInfo textField = CompatibleLayoutRequestValidatorTest.createComponent("javax.swing.JTextField");
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, false, panel, (Object)textField);
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createComponent("javax.swing.JButton");
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, (Object)button);
    }

    @Test
    public void test_childScript_canBeDroppedOnlyOnJPanel() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JPanel panel = new JPanel();", "    getContentPane().add(panel);", "  }", "}");
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createJButton();
        JavaInfoUtils.setParameter((JavaInfo)button, (String)"GEF.requestValidator.child", (String)"isComponentType(parent, 'javax.swing.JPanel')");
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, false, frame, (Object)button);
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo panel = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, (Object)button);
    }

    @Test
    public void test_childWithJPanelConstructor() throws Exception {
        CompatibleLayoutRequestValidatorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(JPanel parent) {", "  }", "}"));
        CompatibleLayoutRequestValidatorTest.setFileContentSrc("test/MyButton.wbp-component.xml", CompatibleLayoutRequestValidatorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <constructors>", "    <constructor>", "      <parameter type='javax.swing.JPanel' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        CompatibleLayoutRequestValidatorTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JPanel panel = new JPanel();", "    getContentPane().add(panel);", "  }", "}");
        ComponentInfo button = CompatibleLayoutRequestValidatorTest.createComponent("test.MyButton");
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, false, frame, (Object)button);
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo panel = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        CompatibleLayoutRequestValidatorTest.assert_validateCMA(validator, true, panel, (Object)button);
    }

    @Test
    public void test_paste_noChecks() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CompatibleLayoutRequestValidatorTest.assert_validatePasteRequest(validator, true, panel, (JavaInfo)button);
    }
}

