/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.SuperConstructorAccessor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SuperConstructorAccessorTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        SuperConstructorAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(boolean enabled) {", "    setEnabled(enabled);", "  }", "}"));
        SuperConstructorAccessorTest.waitForAutoBuild();
    }

    @Test
    public void test_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(false);", "  }", "}");
        SuperConstructorAccessor accessor = SuperConstructorAccessorTest.getAccessor(panel, null);
        SuperConstructorAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)accessor.getDefaultValue((JavaInfo)panel));
        SuperConstructorAccessorTest.assertEquals((Object)false, (Object)((BooleanLiteral)accessor.getExpression((JavaInfo)panel)).booleanValue());
    }

    @Test
    public void test_setExpression_newValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(false);", "  }", "}");
        SuperConstructorAccessor accessor = SuperConstructorAccessorTest.getAccessor(panel, null);
        SuperConstructorAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)panel, "true"));
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    super(true);", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue_noDefault() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(true);", "  }", "}");
        SuperConstructorAccessor accessor = SuperConstructorAccessorTest.getAccessor(panel, null);
        SuperConstructorAccessorTest.assertFalse((boolean)accessor.setExpression((JavaInfo)panel, null));
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    super(true);", "  }", "}");
    }

    @Test
    public void test_setExpression_nullValue_withDefault() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    super(true);", "  }", "}");
        SuperConstructorAccessor accessor = SuperConstructorAccessorTest.getAccessor(panel, "new java.lang.String().equals(null)");
        SuperConstructorAccessorTest.assertTrue((boolean)accessor.setExpression((JavaInfo)panel, null));
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    super(new String().equals(null));", "  }", "}");
    }

    private static SuperConstructorAccessor getAccessor(ContainerInfo panel, String defaultSource) {
        MethodDeclaration constructor = ((ThisCreationSupport)panel.getCreationSupport()).getConstructor();
        SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)constructor.getBody().statements().get(0);
        return new SuperConstructorAccessor(superConstructorInvocation, 0, defaultSource);
    }
}

