/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.parser;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.wb.internal.core.parser.ParseFactoryNoModel;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class SimpleParserTest
extends SwingModelTest {
    private static String PARSE_FACTORIES_POINT_ID = "org.eclipse.wb.core.java.parseFactories";

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_thisPanel_empty() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_thisPanel_withButton() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
    }

    @Test
    public void test_thisPanel_withButton_casted() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = (JButton) new JButton();", "      add(button);", "    }", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /(JButton) new JButton()/ /add(button)/}");
    }

    @Test
    public void test_thisPanel_implicitLayout_casted() throws Exception {
        this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  public Test() {", "    FlowLayout flowLayout = (FlowLayout) getLayout();", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {local-unique: flowLayout} {/getLayout()/ /(FlowLayout) getLayout()/}");
    }

    @Test
    public void test_thisFrame_empty() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
    }

    @Test
    public void test_thisFrame_withButton() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/getContentPane().add(button)/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /getContentPane().add(button)/}");
    }

    @Test
    public void test_lazy() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {lazy: button getButton()} {/new JButton()/ /button/ /add(getButton())/}");
    }

    @Test
    public void test_exposedField_reference_SimpleName() throws Exception {
        SimpleParserTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        SimpleParserTest.waitForAutoBuild();
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    m_container.setEnabled(false);", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {field: javax.swing.JPanel} {m_container} {/m_container.setEnabled(false)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_exposedField_reference_QualifiedName() throws Exception {
        SimpleParserTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public final JPanel m_container;", "  public MyPanel() {", "    setLayout(new BorderLayout());", "    {", "      m_container = new JPanel();", "      add(m_container, BorderLayout.CENTER);", "    }", "  }", "}"));
        SimpleParserTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.m_container.setEnabled(false);", "  }", "}");
        SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/ /add(myPanel)/ /myPanel.m_container/}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "    {field: javax.swing.JPanel} {m_container} {/myPanel.m_container.setEnabled(false)/}", "      {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_noModel() throws Exception {
        TestUtils.addDynamicExtension(PARSE_FACTORIES_POINT_ID, "  <noModel class='" + TestParseFactory_noModel.class.getName() + "'/>");
        try {
            this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JTextField());", "    createLabel();", "  }", "  void createLabel() {", "    add(new JLabel());", "  }", "}");
            SimpleParserTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/ /add(new JTextField())/ /add(new JLabel())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        }
        finally {
            TestUtils.removeDynamicExtension(PARSE_FACTORIES_POINT_ID);
        }
    }

    public static final class TestParseFactory_noModel
    extends ParseFactoryNoModel {
        public boolean noModel(ASTNode node) {
            MethodDeclaration enclosingMethod = AstNodeUtils.getEnclosingMethod((ASTNode)node);
            if (enclosingMethod != null) {
                return "createLabel".equals(enclosingMethod.getName().toString());
            }
            return false;
        }

        public boolean noModel(ClassInstanceCreation creation, ITypeBinding typeBinding) {
            return AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"javax.swing.JTextField");
        }
    }
}

