/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.databinding;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObjectsTreeContentProvider;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.tests.designer.core.model.TestObjectInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class ObjectsTreeContentProviderTest
extends DesignerTestCase {
    @Test
    public void test_input() throws Exception {
        ObjectsTreeContentProvider provider = new ObjectsTreeContentProvider();
        ObjectsTreeContentProviderTest.assertSame((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)provider.getElements(null));
        ObjectsTreeContentProviderTest.assertSame((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)provider.getElements((Object)"test"));
        TestObjectInfo testObject = new TestObjectInfo("testObject");
        Assertions.assertThat((Object[])provider.getElements((Object)new Object[]{testObject})).containsOnly(new Object[]{testObject});
        ArrayList<TestObjectInfo> input = new ArrayList<TestObjectInfo>();
        input.add(testObject);
        Assertions.assertThat((Object[])provider.getElements(input)).containsOnly(new Object[]{testObject});
        TestObjectInfo childObject = new TestObjectInfo("childObject");
        testObject.addChild(childObject);
        Assertions.assertThat((Object[])provider.getElements((Object)testObject)).containsOnly(new Object[]{childObject});
        provider.inputChanged(null, null, null);
        provider.dispose();
    }

    @Test
    public void test_getParent() throws Exception {
        ObjectsTreeContentProvider provider = new ObjectsTreeContentProvider();
        ObjectsTreeContentProviderTest.assertNull((Object)provider.getParent(null));
        ObjectsTreeContentProviderTest.assertNull((Object)provider.getParent((Object)"test"));
        TestObjectInfo testObject = new TestObjectInfo("testObject");
        TestObjectInfo childObject = new TestObjectInfo("childObject");
        testObject.addChild(childObject);
        ObjectsTreeContentProviderTest.assertNull((Object)provider.getParent((Object)testObject));
        ObjectsTreeContentProviderTest.assertSame((Object)((Object)testObject), (Object)provider.getParent((Object)childObject));
    }

    @Test
    public void test_hasChildren() throws Exception {
        ObjectsTreeContentProvider provider = new ObjectsTreeContentProvider();
        ObjectsTreeContentProviderTest.assertFalse((boolean)provider.hasChildren(null));
        ObjectsTreeContentProviderTest.assertFalse((boolean)provider.hasChildren((Object)"test"));
        TestObjectInfo testObject = new TestObjectInfo("testObject");
        ObjectsTreeContentProviderTest.assertFalse((boolean)provider.hasChildren((Object)testObject));
        TestObjectInfo childObject = new TestObjectInfo("childObject");
        testObject.addChild(childObject);
        ObjectsTreeContentProviderTest.assertTrue((boolean)provider.hasChildren((Object)testObject));
        TestObjectInfo testObjectPresentation = new TestObjectInfo("testObjectPresentation"){

            @Override
            public IObjectPresentation getPresentation() {
                return new DefaultObjectPresentation(this){

                    public String getText() throws Exception {
                        return "testObjectPresentation";
                    }

                    public boolean isVisible() throws Exception {
                        return false;
                    }
                };
            }
        };
        testObjectPresentation.addChild(new TestObjectInfo("childObject"));
        ObjectsTreeContentProviderTest.assertFalse((boolean)provider.hasChildren((Object)testObjectPresentation));
    }

    @Test
    public void test_getChildren() throws Exception {
        ObjectsTreeContentProvider provider = new ObjectsTreeContentProvider();
        ObjectsTreeContentProviderTest.assertSame((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)provider.getChildren(null));
        ObjectsTreeContentProviderTest.assertSame((Object)ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)provider.getChildren((Object)"test"));
        TestObjectInfo testObject = new TestObjectInfo("testObject");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])provider.getChildren((Object)testObject)).isNotNull()).isEmpty();
        TestObjectInfo childObject = new TestObjectInfo("childObject");
        testObject.addChild(childObject);
        Assertions.assertThat((Object[])provider.getChildren((Object)testObject)).containsOnly(new Object[]{childObject});
    }
}

