/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;

public final class ZipFileFactory {
    private final ZipOutputStream m_zipStream;

    public ZipFileFactory(OutputStream outputStream) throws IOException {
        this.m_zipStream = new ZipOutputStream(outputStream);
    }

    public void close() throws IOException {
        this.m_zipStream.close();
    }

    public ZipFileFactory add(String path, String content) throws IOException {
        this.add(path, new ByteArrayInputStream(content.getBytes()));
        return this;
    }

    public ZipFileFactory add(String path, InputStream inputStream) throws IOException {
        this.m_zipStream.putNextEntry(new ZipEntry(path));
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.m_zipStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        this.m_zipStream.closeEntry();
        return this;
    }

    public ZipFileFactory add(String path, File file) throws IOException {
        path = (String)path + "/" + file.getName();
        if (file.isFile()) {
            this.add((String)path, new FileInputStream(file));
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.add((String)path, child);
                ++n2;
            }
        }
        return this;
    }

    public ZipFileFactory addClass(Class<?> clazz) throws IOException {
        String path = clazz.getName().replace('.', '/') + ".class";
        InputStream classBytes = TestBundle.getClassBytes(clazz);
        this.add(path, classBytes);
        return this;
    }
}

