/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.handles;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public abstract class Handle
extends Figure
implements AncestorListener {
    private final GraphicalEditPart m_owner;
    private final Locator m_locator;
    private Tool m_dragTracker;

    public Handle(GraphicalEditPart owner, Locator locator) {
        this.m_owner = owner;
        this.m_locator = locator;
    }

    public void addNotify() {
        super.addNotify();
        this.getOwnerFigure().addAncestorListener(this);
        this.revalidate();
    }

    public void removeNotify() {
        this.getOwnerFigure().removeAncestorListener(this);
        super.removeNotify();
    }

    public void ancestorMoved(IFigure ancestor) {
        this.revalidate();
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    public void revalidate() {
        this.getLocator().relocate((IFigure)this);
    }

    protected final GraphicalEditPart getOwner() {
        return this.m_owner;
    }

    protected final Figure getOwnerFigure() {
        return this.getOwner().getFigure();
    }

    protected final Locator getLocator() {
        return this.m_locator;
    }

    public Tool getDragTrackerTool() {
        if (this.m_dragTracker == null) {
            this.m_dragTracker = this.createDragTrackerTool();
        }
        return this.m_dragTracker;
    }

    public void setDragTrackerTool(Tool dragTracker) {
        this.m_dragTracker = dragTracker;
    }

    protected final Tool createDragTrackerTool() {
        return null;
    }
}

