/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagDynamicInitializer;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationsControllerResources;
import org.eclipse.jst.common.internal.annotations.registry.TagAttribSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagSpec;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class AnnotationTagRegistry {
    private static boolean initialized = false;
    private static final String ANNOTATION_TAG_INFO = "org.eclipse.jst.common.annotations.controller.AnnotationTagInfo";
    private static ArrayList allTagSpecs = new ArrayList(){
        private static final long serialVersionUID = 8683452581122892190L;

        private void scopeAll(Collection c, boolean forAdd) {
            for (TagSpec ts : c) {
                if (forAdd) {
                    this.addScope(ts);
                    continue;
                }
                this.removeScope(ts);
            }
        }

        private void addScope(TagSpec ts) {
            if (ts == null) {
                return;
            }
            switch (ts.getScope()) {
                case 2: {
                    fieldTags.put(ts.getTagName(), ts);
                    break;
                }
                case 0: {
                    methodTags.put(ts.getTagName(), ts);
                    break;
                }
                case 1: {
                    typeTags.put(ts.getTagName(), ts);
                }
            }
        }

        private void removeScope(TagSpec ts) {
            if (ts == null) {
                return;
            }
            switch (ts.getScope()) {
                case 2: {
                    fieldTags.remove(ts.getTagName());
                    break;
                }
                case 0: {
                    methodTags.remove(ts.getTagName());
                    break;
                }
                case 1: {
                    typeTags.remove(ts.getTagName());
                }
            }
        }

        public void add(int index, Object element) {
            super.add(index, element);
            this.addScope((TagSpec)element);
        }

        public boolean add(Object o) {
            TagSpec newTagSpec = (TagSpec)o;
            int i = 0;
            while (i < this.size()) {
                TagSpec tagSpec = (TagSpec)this.get(i);
                if (tagSpec.getTagName().equals(newTagSpec.getTagName()) && tagSpec.getScope() == newTagSpec.getScope()) {
                    this.remove(tagSpec);
                    this.removeScope(tagSpec);
                }
                ++i;
            }
            this.addScope(newTagSpec);
            return super.add(newTagSpec);
        }

        public boolean addAll(Collection c) {
            this.scopeAll(c, true);
            return super.addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            this.scopeAll(c, true);
            return super.addAll(index, c);
        }

        public Object remove(int index) {
            Object result = super.remove(index);
            this.removeScope((TagSpec)result);
            return result;
        }

        public boolean remove(Object o) {
            this.removeScope((TagSpec)o);
            return super.remove(o);
        }

        public boolean removeAll(Collection c) {
            this.scopeAll(c, false);
            return super.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            for (TagSpec ts : this) {
                if (c.contains(ts)) continue;
                this.removeScope(ts);
            }
            return super.retainAll(c);
        }
    };
    private static Hashtable tagAttribs = new Hashtable();
    private static Map methodTags = new HashMap();
    private static Map typeTags = new HashMap();
    private static Map fieldTags = new HashMap();
    private static final String CLASS_PROP = "class";
    private static final String DYNAMIC_INITIALIZER_EX_PT = "annotationTagDynamicInitializer";
    private static final String ANNOTATIONS_CONTROLLER_NAMESPACE = "org.eclipse.jst.common.annotations.controller";

    static {
        try {
            AnnotationTagRegistry.init();
        }
        catch (CoreException e) {
            Logger.getLogger().logError(AnnotationsControllerResources.AnnotationTagRegistry_ERROR_1);
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private static InitTagInfo parseTagAttribs(IConfigurationElement[] elems, String tagName, String scope) {
        ArrayList<TagAttribSpec> attribList = new ArrayList<TagAttribSpec>();
        InitTagInfo tagInf = new InitTagInfo(tagName, scope, attribList);
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement elem = elems[i];
            if (elem.getName().equalsIgnoreCase("attrib")) {
                TagAttribSpec tas = new TagAttribSpec(elem.getAttribute("name"), elem.getAttribute("description"));
                String use = elem.getAttribute("use");
                tas.setType(elem.getAttribute("type"));
                if ("enum".equals(elem.getAttribute("type"))) {
                    IConfigurationElement[] validValues = elem.getChildren("enumValues");
                    ArrayList<String> valuesList = new ArrayList<String>();
                    int j = 0;
                    while (j < validValues.length) {
                        String value = validValues[j].getAttribute("value");
                        valuesList.add(value);
                        ++j;
                    }
                    String[] validValuesArray = new String[valuesList.size()];
                    validValuesArray = valuesList.toArray(validValuesArray);
                    tas.setValidValues(validValuesArray);
                }
                if (use == null) {
                    tas.clearRequired();
                } else if (use.equalsIgnoreCase("required")) {
                    tas.setRequired();
                } else if (use.equalsIgnoreCase("optional")) {
                    tas.clearRequired();
                } else {
                    System.err.println(String.valueOf(AnnotationsControllerResources.AnnotationTagRegistry_9) + use);
                    return null;
                }
                IConfigurationElement[] elemUniqueArray = elem.getChildren("unique");
                if (elemUniqueArray.length > 0) {
                    tas.setUnique();
                    if (elemUniqueArray[0].getAttribute("scope") != null) {
                        tas.getUnique().setScope(TagAttribSpec.uniqueScopeFromString(elemUniqueArray[0].getAttribute("scope")));
                    }
                    if (elemUniqueArray.length > 1) {
                        Logger.getLogger().logError(String.valueOf(AnnotationsControllerResources.TagAttribSpec_2) + elemUniqueArray.length);
                    }
                } else {
                    tas.clearUnique();
                }
                attribList.add(tas);
            }
            ++i;
        }
        return tagInf;
    }

    public static String tagSetFromTagName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return "";
    }

    public static String tagFromTagName(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(46);
        if (idx != -1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    private static void readAllAttributeInfo(IExtensionPoint xp) {
        if (xp == null) {
            return;
        }
        IExtension[] exts = xp.getExtensions();
        Bundle bundle = null;
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] elems = exts[i].getConfigurationElements();
            bundle = Platform.getBundle((String)exts[i].getNamespace());
            String identifier = exts[i].getUniqueIdentifier();
            IConfigurationElement elem = null;
            String tagName = null;
            String scope = null;
            String tagSet = null;
            String fullTagName = null;
            int j = 0;
            while (j < elems.length) {
                elem = elems[j];
                if (elem.getName().equalsIgnoreCase("AnnotationTagInfo")) {
                    tagSet = elem.getAttribute("tagSet");
                    tagName = elem.getAttribute("tagName");
                    scope = elem.getAttribute("scope");
                    if (AnnotationTagRegistry.isNullOrEmpty(tagSet) || AnnotationTagRegistry.isNullOrEmpty(tagName) || AnnotationTagRegistry.isNullOrEmpty(scope)) {
                        Logger.getLogger().log((Object)NLS.bind((String)AnnotationsControllerResources.AnnotationTagRegistry_10, (Object[])new Object[]{identifier}));
                    } else {
                        fullTagName = String.valueOf(tagSet) + "." + tagName;
                        InitTagInfo tagInf = AnnotationTagRegistry.parseTagAttribs(elem.getChildren(), fullTagName.toLowerCase(), scope);
                        String key = (String.valueOf(fullTagName) + "#" + scope).toLowerCase();
                        if (tagAttribs.containsKey(key)) {
                            Logger.getLogger().log((Object)(String.valueOf(AnnotationsControllerResources.AnnotationTagRegistry_0) + tagName + "'."));
                        } else {
                            tagInf.bundle = bundle;
                            tagAttribs.put(key, tagInf);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    private static boolean init() throws CoreException {
        if (initialized) {
            return true;
        }
        AnnotationTagRegistry.initializeStaticTagDefinitions();
        AnnotationTagRegistry.initiaizeDynamicTagDefinitions();
        initialized = true;
        tagAttribs = null;
        return true;
    }

    private static void initializeStaticTagDefinitions() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xp = registry.getExtensionPoint(ANNOTATION_TAG_INFO);
        if (xp == null) {
            return;
        }
        IExtension[] x = xp.getExtensions();
        AnnotationTagRegistry.readAllAttributeInfo(xp);
        int j = 0;
        while (j < x.length) {
            IConfigurationElement[] tagSpecs = x[j].getConfigurationElements();
            int i = 0;
            while (i < tagSpecs.length) {
                IConfigurationElement tagSpec = tagSpecs[i];
                String tagName = String.valueOf(tagSpec.getAttribute("tagSet")) + "." + tagSpec.getAttribute("tagName");
                String scope = tagSpec.getAttribute("scope");
                String multiplicity = tagSpec.getAttribute("multiplicity");
                TagSpec ts = null;
                ts = multiplicity != null ? new TagSpec(tagName, TagSpec.scopeFromString(scope), TagSpec.multiplicityFromString(multiplicity)) : new TagSpec(tagName, TagSpec.scopeFromString(scope), 1);
                String key = (String.valueOf(tagName) + "#" + scope).toLowerCase();
                InitTagInfo tagInf = (InitTagInfo)tagAttribs.get(key);
                allTagSpecs.add(ts);
                if (tagInf != null) {
                    ts.setAttributes(tagInf.attributes);
                    ts.setBundle(tagInf.bundle);
                }
                ++i;
            }
            ++j;
        }
    }

    private static void initiaizeDynamicTagDefinitions() {
        IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint(ANNOTATIONS_CONTROLLER_NAMESPACE, DYNAMIC_INITIALIZER_EX_PT);
        if (xp == null) {
            return;
        }
        IExtension[] extensions = xp.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    AnnotationTagDynamicInitializer initializer = (AnnotationTagDynamicInitializer)elements[j].createExecutableExtension(CLASS_PROP);
                    initializer.registerTags();
                }
                catch (CoreException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                ++j;
            }
            ++i;
        }
    }

    public static synchronized List getAllTagSpecs() {
        return allTagSpecs;
    }

    public static synchronized boolean isMethodTag(String tagName) {
        return methodTags.containsKey(tagName);
    }

    public static synchronized boolean isFieldTag(String tagName) {
        return fieldTags.containsKey(tagName);
    }

    public static synchronized boolean isTypeTag(String tagName) {
        return typeTags.containsKey(tagName);
    }

    public static synchronized TagSpec getMethodTag(String tagName) {
        return (TagSpec)methodTags.get(tagName);
    }

    public static synchronized TagSpec getFieldTag(String tagName) {
        return (TagSpec)fieldTags.get(tagName);
    }

    public static synchronized TagSpec getTypeTag(String tagName) {
        return (TagSpec)typeTags.get(tagName);
    }

    private static class InitTagInfo {
        private String name;
        private List attributes;
        private Bundle bundle;
        private String scope;

        public InitTagInfo(String name, String scope, List att) {
            this.attributes = att;
            this.name = name;
            this.scope = scope;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InitTagInfo)) {
                return false;
            }
            return this.name.equals(((InitTagInfo)obj).name) || this.scope.equals(((InitTagInfo)obj).name);
        }

        public int hashCode() {
            return super.hashCode() + this.name.hashCode();
        }
    }
}

