/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.virgo.ide.runtime.internal.ui.sorters.ArtefactSignatureSorter;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;

public class ServerOutlinePage
extends ContentOutlinePage {
    private CommonViewer contentOutlineViewer;
    protected Object input;
    final ServerEditor editor;

    public ServerOutlinePage(ServerEditor editor) {
        this.editor = editor;
    }

    private IEditorPart getActiveEditor() {
        try {
            Method method = MultiPageEditorPart.class.getDeclaredMethod("getActiveEditor", new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)this.editor, new Object[0]);
            return (IEditorPart)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Control getControl() {
        return this.contentOutlineViewer.getControl();
    }

    protected TreeViewer getTreeViewer() {
        return this.contentOutlineViewer;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.contentOutlineViewer = new CommonViewer("org.eclipse.virgo.ide.runtime.ui.OutlineView", parent, 770);
        this.contentOutlineViewer.setInput((Object)this.editor);
        this.contentOutlineViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ISelection selection = ServerOutlinePage.this.getTreeViewer().getSelection();
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSel = (TreeSelection)selection;
                    if (treeSel.getPaths().length > 0) {
                        TreePath firstPath = treeSel.getPaths()[0];
                        if (firstPath.getFirstSegment() instanceof IEditorPart) {
                            ISelectionChangedListener pageListener;
                            IEditorPart newPart = (IEditorPart)firstPath.getFirstSegment();
                            if (ServerOutlinePage.this.getActiveEditor() != newPart) {
                                ServerOutlinePage.this.editor.setActiveEditor(newPart);
                            }
                            ArrayList<Object> leafList = new ArrayList<Object>();
                            TreePath[] treePathArray = treeSel.getPaths();
                            int n = treePathArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreePath path = treePathArray[n2];
                                leafList.add(path.getLastSegment());
                                ++n2;
                            }
                            if (leafList.size() > 0 && (pageListener = (ISelectionChangedListener)newPart.getAdapter(ISelectionChangedListener.class)) instanceof ISelectionChangedListener) {
                                pageListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ServerOutlinePage.this.getTreeViewer(), (ISelection)new StructuredSelection(leafList)));
                            }
                        }
                    } else if (sel.getFirstElement() instanceof IEditorPart) {
                        ServerOutlinePage.this.editor.setActiveEditor((IEditorPart)sel.getFirstElement());
                    }
                }
            }
        });
        this.contentOutlineViewer.setSorter((ViewerSorter)new ArtefactSignatureSorter());
        this.registerContextMenu((StructuredViewer)this.contentOutlineViewer);
    }

    protected void registerContextMenu(StructuredViewer viewer) {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("Something", manager, (ISelectionProvider)viewer);
    }

    class SortingAction
    extends Action {
        private boolean sortingOn;

        public SortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.pde.doc.user.outline_sort_action");
            this.setText(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_label);
            this.setImageDescriptor(PDEPluginImages.DESC_ALPHAB_SORT_CO);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_ALPHAB_SORT_CO_DISABLED);
            this.setToolTipText(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_tooltip);
            this.setDescription(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_description);
            this.setChecked(this.sortingOn);
        }

        public void run() {
            this.setChecked(this.isChecked());
            this.valueChanged(this.isChecked());
        }

        private void valueChanged(boolean on) {
            this.sortingOn = on;
            PDEPlugin.getDefault().getPreferenceStore().setValue("PDEMultiPageContentOutline.SortingAction.isChecked", on);
        }
    }
}

