/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyDeployerPortCommand;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyDeployerTimeoutCommand;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerDeployEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    protected int port;
    protected Text portText;
    protected int timeout;
    protected Text timeoutText;
    protected boolean updating;
    protected PropertyChangeListener listener;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ServerDeployEditorSection.this.updating) {
                    return;
                }
                ServerDeployEditorSection.this.updating = true;
                if ("org.eclipse.virgo.ide.runtime.coredeploy.timeout".equals(event.getPropertyName())) {
                    ServerDeployEditorSection.this.timeoutText.setText(event.getNewValue().toString());
                } else if ("org.eclipse.virgo.ide.runtime.coredeployer.port".equals(event.getPropertyName())) {
                    ServerDeployEditorSection.this.portText.setText(event.getNewValue().toString());
                }
                ServerDeployEditorSection.this.updating = false;
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 394);
        section.setText(Messages.ServerDeployEditorSection_title);
        section.setDescription(Messages.ServerDeployEditorSection_description);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768, 1040, true, false));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        Label portLabel = toolkit.createLabel(composite, Messages.ServerDeployEditorSection_port_label);
        portLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.portText = toolkit.createText(composite, "");
        GridData data = new GridData(4, 0x1000000, true, false);
        this.portText.setLayoutData((Object)data);
        Label timeoutLabel = toolkit.createLabel(composite, Messages.ServerDeployEditorSection_timeout_label);
        timeoutLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.timeoutText = toolkit.createText(composite, "");
        this.timeoutText.setLayoutData((Object)data);
        this.port = this.serverWorkingCopy.getMBeanServerPort();
        this.timeout = this.serverWorkingCopy.getDeployTimeout();
        this.initialize();
        this.addConfigurationChangeListener();
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerDeployEditorSection.this.updating) {
                    return;
                }
                ServerDeployEditorSection.this.getManagedForm().getMessageManager().removeMessages((Control)ServerDeployEditorSection.this.portText);
                int newPort = -1;
                try {
                    newPort = Integer.valueOf(ServerDeployEditorSection.this.portText.getText());
                }
                catch (NumberFormatException nfe) {
                    ServerDeployEditorSection.this.getManagedForm().getMessageManager().addMessage((Object)"MALFORMED-PORT", Messages.ServerDeployEditorSection_invalid_port_form_error, null, 3, (Control)ServerDeployEditorSection.this.portText);
                    return;
                }
                ServerDeployEditorSection.this.setErrorMessage(null);
                ServerDeployEditorSection.this.updating = true;
                ServerDeployEditorSection.this.execute((IUndoableOperation)new ChangePortUICommand(newPort));
                ServerDeployEditorSection.this.updating = false;
            }
        });
        this.timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerDeployEditorSection.this.updating) {
                    return;
                }
                ServerDeployEditorSection.this.getManagedForm().getMessageManager().removeMessages((Control)ServerDeployEditorSection.this.timeoutText);
                Integer newTimeout = null;
                try {
                    newTimeout = Integer.valueOf(ServerDeployEditorSection.this.timeoutText.getText());
                }
                catch (NumberFormatException nfe) {
                    ServerDeployEditorSection.this.getManagedForm().getMessageManager().addMessage((Object)"MALFORMED-TIMEOUT", Messages.ServerDeployEditorSection_invalid_timeout_form_error, null, 3, (Control)ServerDeployEditorSection.this.timeoutText);
                    return;
                }
                if (newTimeout < 5) {
                    ServerDeployEditorSection.this.getManagedForm().getMessageManager().addMessage((Object)"INVALID-TIMEOUT", Messages.ServerDeployEditorSection_timeout_too_small_form_error, null, 3, (Control)ServerDeployEditorSection.this.timeoutText);
                    return;
                }
                ServerDeployEditorSection.this.updating = true;
                ServerDeployEditorSection.this.execute((IUndoableOperation)new ChangeDeployerTimeoutUICommand(newTimeout));
                ServerDeployEditorSection.this.updating = false;
            }
        });
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initialize() {
        this.portText.setText(Integer.toString(this.port));
        this.timeoutText.setText(Integer.toString(this.timeout));
    }

    public IStatus[] getSaveStatus() {
        try {
            Integer.valueOf(this.portText.getText());
        }
        catch (NumberFormatException nfe) {
            String errorMessage = NLS.bind((String)Messages.ServerDeployEditorSection_invalid_port_save_message, (Object)this.portText.getText());
            return new IStatus[]{new Status(4, "org.eclipse.virgo.ide.runtime.ui", errorMessage)};
        }
        try {
            Integer.valueOf(this.timeoutText.getText());
        }
        catch (NumberFormatException nfe) {
            String errorMessage = NLS.bind((String)Messages.ServerDeployEditorSection_invalid_timeout_save_message, (Object)this.timeoutText.getText());
            return new IStatus[]{new Status(4, "org.eclipse.virgo.ide.runtime.ui", errorMessage)};
        }
        return super.getSaveStatus();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.serverWorkingCopy.getDeployTimeout() != this.timeout) {
            this.execute((IUndoableOperation)new ModifyDeployerTimeoutCommand(this.serverWorkingCopy, this.timeout));
        }
        if (this.serverWorkingCopy.getMBeanServerPort() != this.port) {
            this.execute((IUndoableOperation)new ModifyDeployerPortCommand(this.serverWorkingCopy, this.port));
        }
        super.doSave(monitor);
    }

    class ChangeDeployerTimeoutUICommand
    extends AbstractOperation {
        private int oldValue;
        private int newValue;

        public ChangeDeployerTimeoutUICommand(int newValue) {
            super("Change deployer timeout");
            this.newValue = newValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = ServerDeployEditorSection.this.timeout;
            ServerDeployEditorSection.this.timeout = this.newValue;
            ServerDeployEditorSection.this.updating = true;
            ServerDeployEditorSection.this.initialize();
            ServerDeployEditorSection.this.updating = false;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.newValue = ServerDeployEditorSection.this.timeout;
            ServerDeployEditorSection.this.timeout = this.oldValue;
            ServerDeployEditorSection.this.updating = true;
            ServerDeployEditorSection.this.initialize();
            ServerDeployEditorSection.this.updating = false;
            return Status.OK_STATUS;
        }
    }

    class ChangePortUICommand
    extends AbstractOperation {
        private int oldValue;
        private int newValue;

        public ChangePortUICommand(int newValue) {
            super("Change deployer port");
            this.newValue = newValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.oldValue = ServerDeployEditorSection.this.port;
            ServerDeployEditorSection.this.port = this.newValue;
            ServerDeployEditorSection.this.updating = true;
            ServerDeployEditorSection.this.initialize();
            ServerDeployEditorSection.this.updating = false;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.newValue = ServerDeployEditorSection.this.port;
            ServerDeployEditorSection.this.port = this.oldValue;
            ServerDeployEditorSection.this.updating = true;
            ServerDeployEditorSection.this.initialize();
            ServerDeployEditorSection.this.updating = false;
            return Status.OK_STATUS;
        }
    }
}

