/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.uomo.xml.DOMUtil;
import org.eclipse.uomo.xml.IXMLWriter;
import org.eclipse.uomo.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMXMLWriter
implements IXMLWriter {
    private Document doc = null;
    private boolean isPretty = true;
    private Stack<Node> current = new Stack();
    private Map attributes = new HashMap();
    private Map definedNS = new HashMap();
    private DocumentFragment commentBlock = null;

    public DOMXMLWriter() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
    }

    public DOMXMLWriter(Document doc) {
        this.doc = doc;
    }

    public Document getDOMDocument() {
        return this.doc;
    }

    public Element getCurrentElement() {
        return (Element)this.current.peek();
    }

    protected boolean condition(boolean bTest, String message) throws IOException {
        if (!bTest) {
            throw new IOException(message);
        }
        return bTest;
    }

    private void addAttribute(String name, String value) throws IOException {
        this.addAttribute(name, value, false);
    }

    private void addAttribute(String name, String value, boolean isNoLines) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.condition(!this.attributes.containsKey(name), "attempt to define attribute with name " + name + " more than once");
        this.attributes.put(name, XMLUtil.escapeXML(value, null, isNoLines));
    }

    private void defineNamespace(String namespace, String prefix) {
        if (namespace != null) {
            if (prefix == null) {
                prefix = "";
            }
            this.definedNS.put(prefix, namespace);
        }
    }

    private String getPrefixForNamespace(String namespace) throws IOException {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml:";
        }
        String prefix = null;
        if (this.definedNS.containsValue(namespace)) {
            Iterator iter = this.definedNS.keySet().iterator();
            while (prefix == null && iter.hasNext()) {
                Object k = iter.next();
                if (!this.definedNS.get(k).equals(namespace)) continue;
                prefix = k.toString();
            }
        } else if (this.current.size() > 0) {
            prefix = DOMUtil.lookupPrefixForNamespace((Element)this.current.peek(), namespace);
        }
        if (prefix == null) {
            throw new IOException("Namespace " + namespace + " is not defined");
        }
        return String.valueOf(prefix) + ":";
    }

    private String getNamespaceForPrefix(String prefix) throws IOException {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String result = null;
        if (this.definedNS.containsKey(prefix)) {
            result = this.definedNS.get(prefix).toString();
        } else if (this.current.size() > 0) {
            prefix = DOMUtil.lookupNamespaceForPrefix((Element)this.current.peek(), prefix);
        }
        return result == null ? "" : result;
    }

    private void checkInElement() throws IOException {
        this.condition(this.current != null && this.current.size() > 0, "Not in an element");
    }

    @Override
    public boolean abbreviationDefined(String abbreviation) {
        return this.definedNS.containsKey(abbreviation) || this.current.size() > 0 && DOMUtil.lookupNamespaceForPrefix(this.getCurrentElement(), abbreviation) != null;
    }

    @Override
    public void attribute(String namespace, String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(namespace, name, value);
        }
    }

    @Override
    public void attribute(String namespace, String name, String value) throws IOException {
        if (namespace == null || namespace.equals("")) {
            this.addAttribute(name, value);
        } else {
            this.addAttribute(String.valueOf(this.getPrefixForNamespace(namespace)) + name, value);
        }
    }

    @Override
    public void attribute(String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(name, value);
        }
    }

    @Override
    public void attribute(String name, String value) throws IOException {
        this.addAttribute(name, value);
    }

    @Override
    public void attributeNoLines(String name, String value) throws IOException {
        this.addAttribute(name, value, true);
    }

    @Override
    public void cData(String text) throws IOException {
        this.checkInElement();
        this.getCurrentElement().appendChild(this.doc.createCDATASection(text));
    }

    @Override
    public void close(String name) throws IOException {
        if (this.current.size() == 0) {
            throw new IOException("Unable to close null|" + name + ", nothing to close");
        }
        if (!this.getCurrentElement().getNodeName().equals(name)) {
            throw new IOException("Unable to close null|" + name + ", found " + this.getCurrentElement().getNodeName());
        }
        this.close();
    }

    @Override
    public void close(String namespace, String name) throws IOException {
        if (this.current.size() == 0) {
            throw new IOException("Unable to close null|" + name + ", nothing to close");
        }
        Element ele = this.getCurrentElement();
        if (!namespace.equals(ele.getNamespaceURI()) || !name.equals(ele.getLocalName())) {
            throw new IOException("Unable to close " + namespace + "|" + name + ", found " + ele.getNamespaceURI() + "|" + ele.getLocalName());
        }
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.checkInElement();
        this.current.pop();
    }

    @Override
    public void closeToLevel(int count) throws IOException {
        while (this.current.size() > count) {
            this.close();
        }
    }

    @Override
    public void comment(String comment, boolean doPretty) throws IOException {
        Comment c = this.doc.createComment(comment);
        this.getCurrentElement().appendChild(c);
    }

    @Override
    public void element(String namespace, String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(namespace, name, content);
        }
    }

    @Override
    public void element(String namespace, String name, String content, String comment) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.open(namespace, name, comment);
        this.text(content);
        this.close();
    }

    @Override
    public void element(String namespace, String name, String content) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.open(namespace, name);
        this.text(content);
        this.close();
    }

    @Override
    public void element(String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(null, name, content);
        }
    }

    @Override
    public void element(String name, String content) throws IOException {
        this.element(null, name, content);
    }

    @Override
    public void endCommentBlock() throws IOException {
        if (this.commentBlock == null) {
            throw new IOException("Cannot close a comment block when none existed");
        }
        if (this.getCurrentElement().getParentNode() != this.commentBlock) {
            throw new IOException("Cannot close a comment block when it's still opened");
        }
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        try {
            try {
                NodeList children = this.getCurrentElement().getChildNodes();
                DocumentFragment frag = this.doc.createDocumentFragment();
                int i = 0;
                while (i < children.getLength()) {
                    frag.appendChild(children.item(i));
                    ++i;
                }
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("standalone", "no");
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.transform(new DOMSource(frag), new StreamResult(temp));
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        finally {
            this.current.pop();
            this.commentBlock = null;
        }
        this.comment(temp.toString(), true);
    }

    @Override
    public String getDefaultNamespace() {
        String result = null;
        if (this.definedNS.size() > 0) {
            try {
                result = this.getNamespaceForPrefix("");
            }
            catch (IOException iOException) {}
        }
        if (result == null && this.current.size() > 0) {
            result = DOMUtil.lookupNamespaceForPrefix(this.getCurrentElement(), "");
        }
        return result == null ? "" : result;
    }

    @Override
    public boolean isPretty() throws IOException {
        return this.isPretty;
    }

    @Override
    public void namespace(String namespace) throws IOException {
        if (!this.namespaceDefined(namespace)) {
            int index = 0;
            while (this.abbreviationDefined("ns" + Integer.toString(index))) {
                ++index;
            }
            this.defineNamespace(namespace, "ns" + Integer.toString(index));
        }
    }

    @Override
    public void namespace(String namespace, String prefix) throws IOException {
        String ns = this.getNamespaceForPrefix(prefix);
        if (ns == null || !ns.equals(namespace)) {
            this.defineNamespace(namespace, prefix);
        }
    }

    @Override
    public boolean namespaceDefined(String namespace) {
        try {
            return this.getPrefixForNamespace(namespace) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void open(String namespace, String name) throws IOException {
        this.open(namespace, name, null);
    }

    @Override
    public void open(String namespace, String name, String comment) throws IOException {
        Element ele;
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        if (name == null) {
            throw new IOException("XML name is null");
        }
        if (namespace != null) {
            name = String.valueOf(this.getPrefixForNamespace(namespace)) + name;
            ele = this.doc.createElementNS(namespace, name);
        } else {
            ele = this.getDefaultNamespace().length() > 0 ? this.doc.createElementNS(this.getDefaultNamespace(), name) : this.doc.createElement(name);
        }
        this.defineAttributes(ele);
        this.defineNamespaces(ele);
        if (this.current.size() == 0) {
            this.doc.appendChild(ele);
        } else {
            this.getCurrentElement().appendChild(ele);
        }
        this.current.push(ele);
        if (comment != null) {
            this.comment(comment, true);
        }
    }

    private void defineNamespaces(Element ele) {
        for (Object k : this.definedNS.keySet()) {
            ele.setAttribute("xmlns:" + k.toString(), this.definedNS.get(k).toString());
        }
        this.definedNS.clear();
    }

    private void defineAttributes(Element ele) {
        for (Object k : this.attributes.keySet()) {
            ele.setAttribute(k.toString(), this.attributes.get(k).toString());
        }
        this.attributes.clear();
    }

    @Override
    public void open(String name) throws IOException {
        this.open(null, name);
    }

    @Override
    public void setDefaultNamespace(String namespace) throws IOException {
        if (namespace == null && this.getDefaultNamespace() != null || namespace != null && !namespace.equals(this.getDefaultNamespace())) {
            this.defineNamespace(namespace, "");
        }
    }

    @Override
    public void setPretty(boolean pretty) throws IOException {
        this.isPretty = pretty;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void startCommentBlock() throws IOException {
        if (this.commentBlock != null) {
            throw new IOException("Cannot nest comments");
        }
        this.commentBlock = this.doc.createDocumentFragment();
        Element node = this.doc.createElement("commentRoot");
        this.commentBlock.appendChild(node);
        this.current.push(node);
    }

    @Override
    public void text(String content) throws IOException {
        this.text(content, false);
    }

    @Override
    public void text(String content, boolean dontEscape) throws IOException {
        if (!dontEscape) {
            content = XMLUtil.escapeXML(content, null, false);
        }
        this.checkInElement();
        Text node = this.doc.createTextNode(content);
        this.getCurrentElement().appendChild(node);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.text(new String(bytes));
    }
}

