/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.parsers;

import org.eclipse.uomo.ucum.expression.Component;
import org.eclipse.uomo.ucum.expression.Factor;
import org.eclipse.uomo.ucum.expression.Operator;
import org.eclipse.uomo.ucum.expression.Symbol;
import org.eclipse.uomo.ucum.expression.Term;

public class FormalStructureComposer {
    public String compose(Term term) {
        StringBuilder bldr = new StringBuilder();
        this.composeTerm(bldr, term);
        return bldr.toString();
    }

    private void composeTerm(StringBuilder bldr, Term term) {
        if (term.getComp() != null) {
            this.composeComp(bldr, term.getComp());
        }
        if (term.getOp() != null) {
            this.composeOp(bldr, term.getOp());
        }
        if (term.getTerm() != null) {
            this.composeTerm(bldr, term.getTerm());
        }
    }

    private void composeComp(StringBuilder bldr, Component comp) {
        if (comp instanceof Factor) {
            this.composeFactor(bldr, (Factor)comp);
        } else if (comp instanceof Symbol) {
            this.composeSymbol(bldr, (Symbol)comp);
        } else if (comp instanceof Term) {
            this.composeTerm(bldr, (Term)comp);
        } else {
            bldr.append('?');
        }
    }

    private void composeSymbol(StringBuilder bldr, Symbol symbol) {
        bldr.append('(');
        if (symbol.getPrefix() != null) {
            bldr.append(symbol.getPrefix().getNames().get(0));
        }
        bldr.append(symbol.getUnit().getNames().get(0));
        if (symbol.getExponent() != 1) {
            bldr.append(" ^ ");
            bldr.append(symbol.getExponent());
        }
        bldr.append(')');
    }

    private void composeFactor(StringBuilder bldr, Factor comp) {
        bldr.append(comp.getValue());
    }

    private void composeOp(StringBuilder bldr, Operator op) {
        if (op == Operator.DIVISION) {
            bldr.append(" / ");
        } else {
            bldr.append(" * ");
        }
    }
}

