/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.segmenter;

import com.ibm.icu.segmenter.Segmenter;
import com.ibm.icu.segmenter.Segments;
import com.ibm.icu.segmenter.SegmentsImpl;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;

public class RuleBasedSegmenter
implements Segmenter {
    private final BreakIterator breakIterPrototype;

    @Override
    public Segments segment(CharSequence s) {
        return new SegmentsImpl(this.breakIterPrototype, s);
    }

    public static Builder builder() {
        return new Builder();
    }

    private RuleBasedSegmenter(BreakIterator breakIter) {
        this.breakIterPrototype = breakIter;
    }

    public static class Builder {
        private BreakIterator breakIter = null;

        private Builder() {
        }

        public Builder setRules(String rules) {
            if (rules == null) {
                throw new IllegalArgumentException("rules cannot be set to null.");
            }
            try {
                this.breakIter = new RuleBasedBreakIterator(rules);
                return this;
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("The provided rule string is invalid or there was an error in creating the RuleBasedSegmenter.", rte);
            }
        }

        public Segmenter build() {
            if (this.breakIter == null) {
                throw new IllegalArgumentException("A rule string must be set.");
            }
            return new RuleBasedSegmenter(this.breakIter);
        }
    }
}

