/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStaticAssertDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecStaticAssert;

public class CPPASTStaticAssertionDeclaration
extends ASTNode
implements ICPPASTStaticAssertDeclaration,
IASTAmbiguityParent,
ICPPExecutionOwner {
    private IASTExpression fCondition;
    private final ICPPASTLiteralExpression fMessage;
    public static final ICPPEvaluation STATIC_ASSERT_FAILED = new EvalFixed(ProblemType.STATIC_ASSERT_FAILED, IASTExpression.ValueCategory.PRVALUE, IntegralValue.STATIC_ASSERT_FAILED_ERROR);

    public CPPASTStaticAssertionDeclaration(IASTExpression condition) {
        this(condition, null);
    }

    public CPPASTStaticAssertionDeclaration(IASTExpression condition, ICPPASTLiteralExpression message) {
        this.fCondition = condition;
        this.fMessage = message;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
        }
        if (message != null) {
            message.setParent(this);
            message.setPropertyInParent(MESSAGE);
        }
    }

    @Override
    public IASTExpression getCondition() {
        return this.fCondition;
    }

    @Override
    public ICPPASTLiteralExpression getMessage() {
        return this.fMessage;
    }

    @Override
    public CPPASTStaticAssertionDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTStaticAssertionDeclaration copy(IASTNode.CopyStyle style) {
        IASTExpression condCopy = this.fCondition == null ? null : this.fCondition.copy(style);
        ICPPASTLiteralExpression msgCopy = this.fMessage == null ? null : this.fMessage.copy(style);
        CPPASTStaticAssertionDeclaration copy = new CPPASTStaticAssertionDeclaration(condCopy, msgCopy);
        return this.copy(copy, style);
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fCondition != null && !this.fCondition.accept(action)) {
            return false;
        }
        if (this.fMessage != null && !this.fMessage.accept(action)) {
            return false;
        }
        return !action.shouldVisitDeclarations || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fCondition) {
            this.fCondition = (IASTExpression)other;
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
        }
    }

    @Override
    public ICPPExecution getExecution() {
        ICPPEvaluation iCPPEvaluation;
        IASTExpression iASTExpression = this.getCondition();
        if (iASTExpression instanceof ICPPASTExpression) {
            ICPPASTExpression conditionExpr = (ICPPASTExpression)iASTExpression;
            iCPPEvaluation = conditionExpr.getEvaluation();
        } else {
            iCPPEvaluation = ExecStaticAssert.FAILED;
        }
        ICPPEvaluation conditionExprEval = iCPPEvaluation;
        return new ExecStaticAssert(conditionExprEval);
    }
}

