/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.HistoryTreeStub;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.classic.ClassicHistoryTreeStub;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.overlapping.OverlappingHistoryTreeStub;
import org.eclipse.tracecompass.internal.datastore.core.historytree.HtIo;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HTNodeTest<E extends IHTInterval, N extends HTNode<E>> {
    protected static final ObjectFactory<HTInterval> BASE_OBJ_FACTORY = (s, e) -> new HTInterval(s, e);
    protected static final int BLOCKSIZE = 4096;
    protected static final int NB_CHILDREN = 3;
    private static final long TREE_START = 10L;
    private final HtIo<E, N> fHtIo;
    private final int fHeaderSize;
    private final IHTNode.NodeType fType;
    private final IHTIntervalReader<E> fHtObjectReader;
    private final AbstractHistoryTree.IHTNodeFactory<E, N> fNodeFactory;
    private final ObjectFactory<E> fObjectFactory;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Leaf node", 30, HistoryTreeStub.NODE_FACTORY, HtTestUtils.READ_FACTORY, BASE_OBJ_FACTORY}, {"Classic leaf node", 30, ClassicHistoryTreeStub.CLASSIC_NODE_FACTORY, HtTestUtils.READ_FACTORY, BASE_OBJ_FACTORY}, {"Overlapping leaf node", 30, OverlappingHistoryTreeStub.OVERLAPPING_NODE_FACTORY, HtTestUtils.READ_FACTORY, BASE_OBJ_FACTORY});
    }

    public HTNodeTest(String name, int headerSize, AbstractHistoryTree.IHTNodeFactory<E, N> factory, IHTIntervalReader<E> objReader, ObjectFactory<E> objFactory) throws IOException {
        this(name, headerSize, IHTNode.NodeType.LEAF, factory, objReader, objFactory);
    }

    protected HTNodeTest(String name, int headerSize, IHTNode.NodeType type, AbstractHistoryTree.IHTNodeFactory<E, N> nodeFactory, IHTIntervalReader<E> objReader, ObjectFactory<E> objFactory) throws IOException {
        File file = File.createTempFile("tmp", null);
        Assert.assertNotNull((Object)file);
        this.fHtObjectReader = objReader;
        this.fNodeFactory = nodeFactory;
        this.fHtIo = new HtIo(file, 4096, 3, true, objReader, nodeFactory);
        this.fHeaderSize = headerSize;
        this.fType = type;
        this.fObjectFactory = objFactory;
    }

    public N newNode(int seqNb, int parentNb, long nodeStart) {
        return (N)this.fNodeFactory.createNode(this.fType, 4096, 3, seqNb, parentNb, nodeStart);
    }

    @After
    public void cleanUp() {
        this.fHtIo.deleteFile();
    }

    protected void fillNode(HTNode<E> node, int nbObjects, long start) {
        int i = 0;
        while (i < nbObjects) {
            node.add(this.fObjectFactory.createObject((long)i + start, (long)i + start + 1L));
            ++i;
        }
    }

    protected int getHeaderSize() {
        return this.fHeaderSize;
    }

    protected E createObject(long start, long end) {
        return this.fObjectFactory.createObject(start, end);
    }

    protected void write(HTNode<E> node) throws IOException {
        HtIo<E, N> htIo = this.fHtIo;
        node.writeSelf(htIo.getFileWriter(node.getSequenceNumber()).getChannel());
    }

    protected HTNode<E> read(int seqNb) throws IOException {
        HtIo<E, N> htIo = this.fHtIo;
        return HTNode.readNode((int)4096, (int)3, (FileChannel)htIo.supplyATReader(seqNb).getChannel(), this.fHtObjectReader, this.fNodeFactory);
    }

    @Test
    public void testNodeData() {
        N node = this.newNode(0, -1, 10L);
        Assert.assertFalse((boolean)node.isOnDisk());
        Assert.assertEquals((long)10L, (long)node.getNodeStart());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)node.getNodeEnd());
        Assert.assertEquals((long)0L, (long)node.getSequenceNumber());
        Assert.assertEquals((long)-1L, (long)node.getParentSequenceNumber());
        Assert.assertEquals((long)this.fHeaderSize, (long)node.getTotalHeaderSize());
        Assert.assertTrue((boolean)node.isEmpty());
        Assert.assertEquals((Object)this.fType, (Object)node.getNodeType());
        Assert.assertEquals((long)(4096 - this.fHeaderSize), (long)node.getNodeFreeSpace());
        Assert.assertEquals((long)0L, (long)node.getNodeUsagePercent());
        E object = this.fObjectFactory.createObject(0L, 10L);
        node.add(object);
        Assert.assertEquals((long)(4096 - this.fHeaderSize - object.getSizeOnDisk()), (long)node.getNodeFreeSpace());
        int nbObjects = (4096 - this.fHeaderSize) / object.getSizeOnDisk();
        this.fillNode((HTNode<E>)node, nbObjects - 1, 10L);
        int expectedSize = 4096 - this.fHeaderSize - object.getSizeOnDisk() * nbObjects;
        Assert.assertEquals((long)expectedSize, (long)node.getNodeFreeSpace());
        int expectedNodeUsagePercent = expectedSize == 0 ? 100 : 99;
        Assert.assertEquals((long)expectedNodeUsagePercent, (long)node.getNodeUsagePercent());
        Assert.assertEquals((long)nbObjects, (long)node.getIntervals().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNodeInvalidAdd() {
        N node = this.newNode(0, -1, 10L);
        E object = this.fObjectFactory.createObject(0L, 10L);
        int nbObjects = (4096 - this.fHeaderSize) / object.getSizeOnDisk();
        this.fillNode((HTNode<E>)node, nbObjects, 10L);
        node.add(object);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNodeInvalidEnd() {
        N node = this.newNode(0, -1, 10L);
        E object = this.fObjectFactory.createObject(0L, 10L);
        int nbObjects = (4096 - this.fHeaderSize) / object.getSizeOnDisk();
        this.fillNode((HTNode<E>)node, nbObjects, 10L);
        node.closeThisNode(10L);
    }

    @Test
    public void testAddToCloseNode() {
        N node = this.newNode(0, -1, 10L);
        E object = this.fObjectFactory.createObject(10L, 20L);
        int nbObjects = (4096 - this.fHeaderSize) / object.getSizeOnDisk();
        this.fillNode((HTNode<E>)node, nbObjects - 1, 10L);
        node.closeThisNode(10L + (long)nbObjects);
        node.add(object);
    }

    @Test
    public void testCloseNode() throws IOException {
        N node = this.newNode(0, -1, 10L);
        E object = this.fObjectFactory.createObject(0L, 10L);
        int nbObjects = (4096 - this.fHeaderSize) / object.getSizeOnDisk();
        this.fillNode((HTNode<E>)node, nbObjects, 10L);
        Assert.assertEquals((long)nbObjects, (long)node.getIntervals().size());
        node.closeThisNode(10L + (long)nbObjects + 1L);
        this.write((HTNode<E>)node);
        Assert.assertTrue((boolean)node.isOnDisk());
        HTNode<E> readNode = this.read(0);
        Assert.assertTrue((boolean)readNode.isOnDisk());
        Assert.assertEquals(node, readNode);
    }

    @Test
    public void testNbChildren() {
        N node = this.newNode(0, -1, 10L);
        Assert.assertEquals((long)0L, (long)node.getNbChildren());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetChild() {
        N node = this.newNode(0, -1, 10L);
        node.getChild(0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLatestChild() {
        N node = this.newNode(0, -1, 10L);
        node.getLatestChild();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLinkNewChild() throws IOException {
        N node = this.newNode(0, -1, 10L);
        N childNode = this.newNode(1, 0, 10L);
        node.linkNewChild(childNode);
    }

    protected static interface ObjectFactory<T extends IHTInterval> {
        public T createObject(long var1, long var3);
    }
}

