/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests.htStore;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.overlapping.AbstractOverlappingHistoryTreeTestBase;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree.SegmentTreeNode;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.tests.historytree.SegmentHistoryTreeStub;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class SegmentHistoryTreeTest
extends AbstractOverlappingHistoryTreeTestBase<BasicSegment, SegmentTreeNode<BasicSegment>> {
    private static final BasicSegment DEFAULT_OBJECT = new BasicSegment(0L, 0L);

    protected SegmentHistoryTreeStub<BasicSegment> createHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart) throws IOException {
        return new SegmentHistoryTreeStub<BasicSegment>(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart, BasicSegment.BASIC_SEGMENT_READ_FACTORY);
    }

    protected SegmentHistoryTreeStub<BasicSegment> createHistoryTree(File existingStateFile, int expectedProviderVersion) throws IOException {
        return new SegmentHistoryTreeStub<BasicSegment>(existingStateFile, expectedProviderVersion, BasicSegment.BASIC_SEGMENT_READ_FACTORY);
    }

    protected BasicSegment createInterval(long start, long end) {
        return new BasicSegment(start, end);
    }

    protected long fillValues(AbstractHistoryTree<BasicSegment, SegmentTreeNode<BasicSegment>> ht, int fillSize, long start) {
        int nbValues = fillSize / DEFAULT_OBJECT.getSizeOnDisk();
        int i = 0;
        while (i < nbValues) {
            ht.insert((IHTInterval)this.createInterval(start + (long)i, start + (long)i + 1L));
            ++i;
        }
        return start + (long)nbValues;
    }

    @Test
    public void testIsEmpty() {
        long start = 10L;
        SegmentHistoryTreeStub oht = (SegmentHistoryTreeStub)this.setupSmallTree(3, start);
        Assert.assertTrue((boolean)oht.isEmpty());
        oht.insert((IHTInterval)this.createInterval(start, start + 1L));
        Assert.assertFalse((boolean)oht.isEmpty());
        SegmentTreeNode node = oht.getLatestLeaf();
        long time = this.fillValues((AbstractHistoryTree<BasicSegment, SegmentTreeNode<BasicSegment>>)oht, node.getNodeFreeSpace(), start);
        oht.insert((IHTInterval)this.createInterval(time, time + 1L));
        Assert.assertFalse((boolean)oht.isEmpty());
    }

    @Test
    public void testSizeAndIterator() throws IOException {
        long start = 10L;
        SegmentHistoryTreeStub oht = (SegmentHistoryTreeStub)this.setupSmallTree(3, start);
        int nbSegments = 0;
        Assert.assertEquals((long)nbSegments, (long)oht.size());
        oht.insert((IHTInterval)this.createInterval(start, start + 1L));
        Assert.assertEquals((long)(++nbSegments), (long)oht.size());
        SegmentTreeNode node = oht.getLatestLeaf();
        long time = this.fillValues((AbstractHistoryTree<BasicSegment, SegmentTreeNode<BasicSegment>>)oht, node.getNodeFreeSpace(), start);
        Assert.assertEquals((long)(nbSegments += node.getNodeFreeSpace() / DEFAULT_OBJECT.getSizeOnDisk()), (long)oht.size());
        oht.insert((IHTInterval)this.createInterval(time, time + 1L));
        ++nbSegments;
        oht.insert((IHTInterval)this.createInterval(start, time));
        oht.insert((IHTInterval)this.createInterval(start, start + 10L));
        Assert.assertEquals((long)(nbSegments += 2), (long)oht.size());
        node = oht.getLatestLeaf();
        time = this.fillValues((AbstractHistoryTree<BasicSegment, SegmentTreeNode<BasicSegment>>)oht, node.getNodeFreeSpace(), start);
        Assert.assertEquals((long)(nbSegments += node.getNodeFreeSpace() / DEFAULT_OBJECT.getSizeOnDisk()), (long)oht.size());
        oht.closeTree(oht.getTreeEnd());
        oht = (SegmentHistoryTreeStub)this.createHistoryTreeReader();
        Assert.assertEquals((long)nbSegments, (long)oht.size());
        Iterator iterator = oht.iterator();
        Assert.assertNotNull((Object)iterator);
        int count = Iterators.size((Iterator)iterator);
        Assert.assertEquals((long)nbSegments, (long)count);
        Iterable intersectingElements = oht.getIntersectingElements(start, time);
        count = 0;
        long rangeStart = (long)((double)start + (double)(time - start) * 0.4);
        long rangeEnd = (long)((double)time - (double)(time - start) * 0.4);
        int nbInRange = 0;
        for (BasicSegment segment : intersectingElements) {
            ++count;
            if (segment.getStart() > rangeEnd || rangeStart > segment.getEnd()) continue;
            ++nbInRange;
        }
        Assert.assertEquals((long)nbSegments, (long)count);
        count = Iterators.size(oht.getIntersectingElements(rangeStart, rangeEnd).iterator());
        Assert.assertEquals((long)nbInRange, (long)count);
        Comparator cmp = (Comparator)NonNullUtils.checkNotNull(Comparator.comparing(BasicSegment::getStart));
        SegmentHistoryTreeTest.assertSortedIteration(oht, rangeStart, rangeEnd, cmp, nbInRange);
        cmp = (Comparator)NonNullUtils.checkNotNull(Comparator.comparing(BasicSegment::getEnd));
        SegmentHistoryTreeTest.assertSortedIteration(oht, rangeStart, rangeEnd, cmp, nbInRange);
        cmp = (Comparator)NonNullUtils.checkNotNull(Comparator.comparing(ISegment::getLength));
        SegmentHistoryTreeTest.assertSortedIteration(oht, rangeStart, rangeEnd, cmp, nbInRange);
    }

    private static void assertSortedIteration(SegmentHistoryTreeStub<BasicSegment> oht, long rangeStart, long rangeEnd, Comparator<BasicSegment> cmp, int nbInRange) {
        int count = 0;
        BasicSegment prev = DEFAULT_OBJECT;
        for (BasicSegment segment : oht.getIntersectingElements(rangeStart, rangeEnd, cmp)) {
            Assert.assertTrue((String)("Segment comparison at " + ++count), (cmp.compare(prev, segment) <= 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)nbInRange, (long)count);
    }
}

