/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TimeOffsetTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static final String PROJECT = "Test Project";
    private static final String RESOURCE = "Test Resource";
    private static final long ONE_MS = 1000000L;
    private IFile fResource;

    @Before
    public void setUp() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        this.fResource = project.getFile(RESOURCE);
        if (!this.fResource.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
            this.fResource.create((InputStream)source, true, null);
        }
        this.fResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, this.fResource.getParent().getLocation().toOSString());
    }

    @After
    public void tearDown() throws CoreException {
        if (this.fResource != null && this.fResource.exists()) {
            this.fResource.getProject().delete(true, null);
        }
    }

    private ITmfTrace createAndIndexTrace() throws TmfTraceException {
        TmfTraceStub trace = new TmfTraceStub((IResource)this.fResource, TEST_TRACE.getFullPath(), 1000, false, null);
        trace.indexTrace(true);
        return trace;
    }

    @Test
    public void testNoOffset() throws TmfTraceException {
        ITmfTrace trace = this.createAndIndexTrace();
        TmfContext context = (TmfContext)trace.seekEvent(0L);
        ITmfEvent event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        trace.dispose();
    }

    @Test
    public void testPositiveOffset() throws TmfTraceException {
        ITmfTimestampTransform tt = TimestampTransformFactory.createWithOffset((long)1000000L);
        TimestampTransformFactory.setTimestampTransform((IResource)this.fResource, (ITmfTimestampTransform)tt);
        ITmfTrace trace = this.createAndIndexTrace();
        TmfContext context = (TmfContext)trace.seekEvent(0L);
        ITmfEvent event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)3L, (long)event.getTimestamp().getValue());
        trace.dispose();
    }

    @Test
    public void testNegativeOffset() throws TmfTraceException {
        ITmfTimestampTransform tt = TimestampTransformFactory.createWithOffset((long)-1000000L);
        TimestampTransformFactory.setTimestampTransform((IResource)this.fResource, (ITmfTimestampTransform)tt);
        ITmfTrace trace = this.createAndIndexTrace();
        TmfContext context = (TmfContext)trace.seekEvent(0L);
        ITmfEvent event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)0L, (long)event.getTimestamp().getValue());
        event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        trace.dispose();
    }

    @Test
    public void testClearOffset() throws TmfTraceException {
        ITmfTimestampTransform tt = TimestampTransformFactory.createWithOffset((long)1000000L);
        TimestampTransformFactory.setTimestampTransform((IResource)this.fResource, (ITmfTimestampTransform)tt);
        TimestampTransformFactory.setTimestampTransform((IResource)this.fResource, null);
        ITmfTrace trace = this.createAndIndexTrace();
        TmfContext context = (TmfContext)trace.seekEvent(0L);
        ITmfEvent event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        event = trace.getNext((ITmfContext)context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        trace.dispose();
    }
}

