/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StructDefinitionTest {
    private static final @NonNull String TEST_STRUCT_ID = "testStruct";
    private static final @NonNull String ENUM_2 = "y";
    private static final @NonNull String ENUM_1 = "x";
    private static final @NonNull String TAG_ID = "Tag";
    private static final @NonNull String INT_ID = "_id";
    private static final @NonNull String STRING_ID = "_args";
    private static final @NonNull String ENUM_ID = "_enumArgs";
    private static final @NonNull String SEQUENCE_ID = "_seq";
    private static final @NonNull String LENGTH_SEQ = "_len";
    private static final @NonNull String VAR_FIELD_NAME = "SomeVariant";
    private StructDefinition fixture;
    private StructDefinition emptyStruct;
    private StructDefinition simpleStruct;

    @Before
    public void setUp() throws CTFException {
        StructDeclaration sDec = new StructDeclaration(12L);
        IntegerDeclaration id = IntegerDeclaration.INT_32B_DECL;
        IntegerDeclaration lenDec = IntegerDeclaration.UINT_8_DECL;
        StringDeclaration sd = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        EnumDeclaration ed = new EnumDeclaration(id);
        SequenceDeclaration seqDec = new SequenceDeclaration(LENGTH_SEQ, (IDeclaration)id);
        VariantDeclaration varDec = new VariantDeclaration();
        EnumDeclaration tagDec = new EnumDeclaration(id);
        tagDec.add(0L, 1L, ENUM_1);
        tagDec.add(2L, 3L, ENUM_2);
        varDec.addField(ENUM_2, (IDeclaration)id);
        varDec.addField(ENUM_1, (IDeclaration)sd);
        varDec.setTag(TAG_ID);
        sDec.addField(INT_ID, (IDeclaration)id);
        sDec.addField(STRING_ID, (IDeclaration)sd);
        sDec.addField(ENUM_ID, (IDeclaration)ed);
        sDec.addField(TAG_ID, (IDeclaration)tagDec);
        sDec.addField(LENGTH_SEQ, (IDeclaration)lenDec);
        sDec.addField(SEQUENCE_ID, (IDeclaration)seqDec);
        sDec.addField(VAR_FIELD_NAME, (IDeclaration)varDec);
        byte[] bytes = new byte[100];
        bytes[4] = 1;
        bytes[8] = 2;
        bytes[13] = 3;
        BitBuffer bb = new BitBuffer(Util.testMemory(ByteBuffer.wrap(bytes)));
        this.fixture = sDec.createDefinition(null, TEST_STRUCT_ID, bb);
        EnumDefinition eDef = tagDec.createDefinition((IDefinitionScope)this.fixture, TAG_ID, bb);
        Assert.assertNotNull((Object)eDef);
        VariantDefinition vd = varDec.createDefinition((IDefinitionScope)this.fixture, VAR_FIELD_NAME, bb);
        Assert.assertNotNull((Object)vd);
        StructDeclaration esDec = new StructDeclaration(32L);
        this.emptyStruct = esDec.createDefinition(null, TEST_STRUCT_ID, bb);
        StructDeclaration ssDec = new StructDeclaration(32L);
        ssDec.addField(INT_ID, (IDeclaration)id);
        ssDec.addField(STRING_ID, (IDeclaration)sd);
        this.simpleStruct = ssDec.createDefinition(null, TEST_STRUCT_ID, bb);
    }

    @Test
    public void testGetDeclaration() {
        StructDeclaration result = this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDefinitions_1() {
        Definition result = this.fixture.getDefinition(INT_ID);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupArray() {
        String name = INT_ID;
        AbstractArrayDefinition result = this.fixture.lookupArrayDefinition(name);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupDefinition() {
        String lookupPath = "args";
        Definition result = this.fixture.lookupDefinition(lookupPath);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupEnum() {
        String name = ENUM_ID;
        EnumDefinition result = this.fixture.lookupEnum(name);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupInteger_1() {
        String name = INT_ID;
        IntegerDefinition result = this.fixture.lookupInteger(name);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupInteger_2() {
        String name = VAR_FIELD_NAME;
        IntegerDefinition result = this.fixture.lookupInteger(name);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupFixedStringDefinition() {
        String name = SEQUENCE_ID;
        AbstractArrayDefinition result = this.fixture.lookupArrayDefinition(name);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupString() {
        String name = VAR_FIELD_NAME;
        StringDefinition result = this.fixture.lookupString(name);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupStruct() {
        String name = VAR_FIELD_NAME;
        StructDefinition result = this.fixture.lookupStruct(name);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupVariant() {
        String name = VAR_FIELD_NAME;
        VariantDefinition result = this.fixture.lookupVariant(name);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertNotNull((Object)result);
        result = this.emptyStruct.toString();
        Assert.assertEquals((Object)"{  }", (Object)result);
        result = this.simpleStruct.toString();
        Assert.assertEquals((Object)"{ _id = 0, _args = \"\" }", (Object)result);
    }
}

