/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileContentManager;
import org.eclipse.team.core.IStringMapping;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.preferences.FileTypeTable;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class TextPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final List<FileTypeTable.Item> fItems = new ArrayList<FileTypeTable.Item>();
    private Button fRemoveButton;
    private Button fChangeButton;
    protected FileTypeTable fTable;

    public TextPreferencePage() {
        this.initializeItems();
    }

    private void initializeItems() {
        IStringMapping info;
        this.fItems.clear();
        IFileContentManager manager = Team.getFileContentManager();
        IStringMapping[] extensionInfoArray = manager.getExtensionMappings();
        IStringMapping[] nameInfoArray = manager.getNameMappings();
        Set<String> fPluginNames = TextPreferencePage.makeSetOfStrings(manager.getDefaultNameMappings());
        Set<String> fPluginExtensions = TextPreferencePage.makeSetOfStrings(manager.getDefaultExtensionMappings());
        IStringMapping[] iStringMappingArray = extensionInfoArray;
        int n = extensionInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            info = iStringMappingArray[n2];
            FileTypeTable.Extension extension = new FileTypeTable.Extension(info.getString(), fPluginExtensions.contains(info.getString()));
            extension.mode = info.getType();
            this.fItems.add(extension);
            ++n2;
        }
        iStringMappingArray = nameInfoArray;
        n = nameInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            info = iStringMappingArray[n2];
            FileTypeTable.Name name = new FileTypeTable.Name(info.getString(), fPluginNames.contains(info.getString()));
            name.mode = info.getType();
            this.fItems.add(name);
            ++n2;
        }
    }

    private static Set<String> makeSetOfStrings(IStringMapping[] mappings) {
        HashSet<String> set = new HashSet<String>(mappings.length);
        IStringMapping[] iStringMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            IStringMapping mapping = iStringMappingArray[n2];
            set.add(mapping.getString());
            ++n2;
        }
        return set;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        Composite composite = SWTUtils.createHVFillComposite(parent, 0, 2);
        this.fTable = new FileTypeTable(composite, this.fItems, false);
        this.fTable.getViewer().getControl().addListener(13, e -> this.handleSelection());
        this.fTable.getViewer().addDoubleClickListener(event -> {
            ISelection selection = event.getSelection();
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                return;
            }
            this.fTable.getViewer().editElement(((IStructuredSelection)selection).getFirstElement(), 1);
        });
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        buttonsComposite.setLayout((Layout)SWTUtils.createGridLayout(1, converter, 0));
        Button addExtensionButton = new Button(buttonsComposite, 8);
        addExtensionButton.setText(TeamUIMessages.TextPreferencePage_add);
        Button addNameButton = new Button(buttonsComposite, 8);
        addNameButton.setText(TeamUIMessages.TextPreferencePage_0);
        this.fChangeButton = new Button(buttonsComposite, 8);
        this.fChangeButton.setText(TeamUIMessages.TextPreferencePage_change);
        this.fRemoveButton = new Button(buttonsComposite, 8);
        this.fRemoveButton.setText(TeamUIMessages.TextPreferencePage_remove);
        Label label = new Label(composite, 64);
        label.setText(TeamUIMessages.TextPreferencePage_1);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        int buttonWidth = SWTUtils.calculateControlSize(converter, (Control[])new Button[]{addExtensionButton, addNameButton, this.fChangeButton, this.fRemoveButton});
        addExtensionButton.setLayoutData((Object)SWTUtils.createGridData(buttonWidth, -1, 4, 4, false, false));
        addNameButton.setLayoutData((Object)SWTUtils.createGridData(buttonWidth, -1, 4, 4, false, false));
        this.fChangeButton.setLayoutData((Object)SWTUtils.createGridData(buttonWidth, -1, 4, 4, false, false));
        this.fRemoveButton.setLayoutData((Object)SWTUtils.createGridData(buttonWidth, -1, 4, 4, false, false));
        addExtensionButton.addListener(13, e -> this.addExtension());
        addNameButton.addListener(13, e -> this.addName());
        this.fChangeButton.setEnabled(false);
        this.fChangeButton.addListener(13, e -> this.changePattern());
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addListener(13, e -> this.removePattern());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.ui.file_type_preference_page_context");
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeItems();
        if (this.fTable != null) {
            this.fTable.getViewer().refresh();
        }
    }

    public boolean performOk() {
        ArrayList<String> extensionsList = new ArrayList<String>();
        ArrayList<Integer> extensionsModesList = new ArrayList<Integer>();
        ArrayList<String> namesList = new ArrayList<String>();
        ArrayList<Integer> namesModesList = new ArrayList<Integer>();
        for (FileTypeTable.Item item : this.fItems) {
            if (item instanceof FileTypeTable.Extension) {
                extensionsList.add(item.name);
                extensionsModesList.add(item.mode);
                continue;
            }
            if (!(item instanceof FileTypeTable.Name)) continue;
            namesList.add(item.name);
            namesModesList.add(item.mode);
        }
        String[] extensions = extensionsList.toArray(new String[extensionsList.size()]);
        String[] names = namesList.toArray(new String[namesList.size()]);
        int[] extensionsModes = TextPreferencePage.integerListToIntArray(extensionsModesList);
        int[] namesModes = TextPreferencePage.integerListToIntArray(namesModesList);
        Team.getFileContentManager().setExtensionMappings(extensions, extensionsModes);
        Team.getFileContentManager().setNameMappings(names, namesModes);
        TeamUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.uiglobal_file_types_changed", null, null));
        return true;
    }

    private static int[] integerListToIntArray(List integers) {
        int[] array = new int[integers.size()];
        int index = 0;
        for (Object element : integers) {
            array[index++] = (Integer)element;
        }
        return array;
    }

    void addExtension() {
        FileTypeTable.Item item2;
        ExtensionValidator validator = new ExtensionValidator();
        InputDialog dialog = new InputDialog(this.getShell(), TeamUIMessages.TextPreferencePage_enterExtensionShort, TeamUIMessages.TextPreferencePage_enterExtensionLong, null, (IInputValidator)validator);
        if (dialog.open() != 0) {
            return;
        }
        String extension = validator.strip(dialog.getValue());
        for (FileTypeTable.Item item2 : this.fItems) {
            if (!(item2 instanceof FileTypeTable.Extension) || !item2.name.equals(extension)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)TeamUIMessages.TextPreferencePage_extensionExistsShort, (String)TeamUIMessages.TextPreferencePage_extensionExistsLong);
            return;
        }
        item2 = new FileTypeTable.Extension(extension, false);
        this.fItems.add(item2);
        this.fTable.getViewer().refresh();
    }

    void addName() {
        FileTypeTable.Item item2;
        InputDialog dialog = new InputDialog(this.getShell(), TeamUIMessages.TextPreferencePage_6, TeamUIMessages.TextPreferencePage_7, null, (IInputValidator)new FilenameValidator());
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getValue();
        for (FileTypeTable.Item item2 : this.fItems) {
            if (!(item2 instanceof FileTypeTable.Name) || !item2.name.equals(name)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)TeamUIMessages.TextPreferencePage_extensionExistsShort, (String)TeamUIMessages.TextPreferencePage_extensionExistsLong);
            return;
        }
        item2 = new FileTypeTable.Name(name, false);
        this.fItems.add(item2);
        this.fTable.getViewer().refresh();
    }

    void removePattern() {
        IStructuredSelection selection = this.fTable.getSelection();
        if (selection == null) {
            return;
        }
        for (Object element : selection) {
            FileTypeTable.Item item = (FileTypeTable.Item)element;
            if (item.contributed) continue;
            this.fItems.remove(item);
        }
        this.fTable.getViewer().refresh();
        this.handleSelection();
    }

    void changePattern() {
        IStructuredSelection selection = this.fTable.getSelection();
        if (selection == null) {
            return;
        }
        for (Object element : selection) {
            FileTypeTable.Item item = (FileTypeTable.Item)element;
            item.mode = item.mode == 1 ? 2 : 1;
            this.fTable.getViewer().refresh((Object)item);
        }
    }

    void handleSelection() {
        boolean empty = this.fTable.getSelection().isEmpty();
        FileTypeTable.Item selectedItem = (FileTypeTable.Item)this.fTable.getSelection().getFirstElement();
        this.fRemoveButton.setEnabled(!empty && !selectedItem.contributed);
        this.fChangeButton.setEnabled(!empty);
    }

    private static final class ExtensionValidator
    implements IInputValidator {
        private ExtensionValidator() {
        }

        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "";
            }
            if (!this.isComplete(newText)) {
                return TeamUIMessages.TextPreferencePage_ExtensionNotCompleted;
            }
            if ((newText = this.strip(newText)).indexOf(42) >= 0) {
                return TeamUIMessages.TextPreferencePage_2;
            }
            if (newText.indexOf(46) >= 0) {
                return TeamUIMessages.TextPreferencePage_3;
            }
            return null;
        }

        public String strip(String newText) {
            if ((newText = newText.trim()).startsWith("*")) {
                newText = newText.substring(1);
            }
            if (newText.startsWith(".")) {
                newText = newText.substring(1);
            }
            return newText;
        }

        public boolean isComplete(String text) {
            return !text.equals("*") && !text.equals("*.") && !text.equals(".");
        }
    }

    private static final class FilenameValidator
    implements IInputValidator {
        private FilenameValidator() {
        }

        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "";
            }
            if (newText.indexOf(42) >= 0) {
                return TeamUIMessages.TextPreferencePage_5;
            }
            return null;
        }
    }
}

