/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.registry;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;

class AdapterFactoryRegistryReader {
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ID = "id";
    private static boolean DEBUG = false;
    protected static final String EXTENSION_POINT_ID = "adapterFactoryDescription";
    protected static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    protected static final String TAG_CONTENT_TYPE = "contentType";
    protected static final String TAG_NAME = "adapterFactoryDescription";
    public static final String UNKNOWN_CONTENT_TYPE = "unknown";
    protected IConfigurationElement configElement = null;

    private static void addElementForContentType(HashMap map, String contentTypeId, IConfigurationElement element) {
        Object o = map.get(contentTypeId);
        if (o == null) {
            HashMap<IConfigurationElement, Object> element2provider = new HashMap<IConfigurationElement, Object>();
            element2provider.put(element, null);
            map.put(contentTypeId, element2provider);
            if (DEBUG) {
                System.out.println("added " + element.getAttribute(ATT_CLASS) + ", but didn't create exec extension");
            }
        } else {
            HashMap element2provider = (HashMap)o;
            element2provider.put(element, null);
            if (DEBUG) {
                System.out.println("added " + element.getAttribute(ATT_CLASS) + " to unknown list, but didn't create exec extension");
            }
        }
    }

    protected static AdapterFactoryProvider readElement(IConfigurationElement element, HashMap map) {
        AdapterFactoryProvider adapterFactoryProvider = null;
        if (element.getName().equals("adapterFactoryDescription")) {
            try {
                IConfigurationElement[] children = element.getChildren();
                boolean specifiedContentType = false;
                if (children != null && children.length > 0) {
                    int i = 0;
                    while (i < children.length) {
                        if (children[i].getName().equals(TAG_CONTENT_TYPE)) {
                            specifiedContentType = true;
                            String contentType = children[i].getAttribute(ATT_ID);
                            AdapterFactoryRegistryReader.addElementForContentType(map, contentType, element);
                        }
                        ++i;
                    }
                }
                if (!specifiedContentType) {
                    AdapterFactoryRegistryReader.addElementForContentType(map, UNKNOWN_CONTENT_TYPE, element);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return adapterFactoryProvider;
    }

    static void readRegistry(HashMap map) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PLUGIN_ID, "adapterFactoryDescription");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                AdapterFactoryRegistryReader.readElement(elements[i], map);
                ++i;
            }
        }
    }

    AdapterFactoryRegistryReader() {
    }
}

