/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.gpu.core.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.incubator.gpu.core.handlers.ApiEventHandler;
import org.eclipse.tracecompass.incubator.gpu.core.handlers.IGpuEventHandler;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTrace;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTraceEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class GpuCallStackAnalysis
extends InstrumentedCallStackAnalysis {
    private static final String ID = "org.eclipse.tracecompass.incubator.gpu.core.analysis.callstack";
    private static final String EDGES = "EDGES";
    public static final String ROOT = "root";
    public static final String NAME = "name";
    public static final String CORRELATION_ID = "correlation_id";
    public static final String OPERATION_QUEUES = "operation_queues";

    protected Collection<Integer> getEdgeQuarks() {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        int edgeQuark = ss.optQuarkAbsolute(new String[]{EDGES});
        if (edgeQuark == -2) {
            return Collections.emptyList();
        }
        return ss.getSubAttributes(edgeQuark, false);
    }

    protected ITmfStateProvider createStateProvider() {
        return new GpuCallStackStateProvider(Objects.requireNonNull(this.getTrace()));
    }

    private class GpuCallStackStateProvider
    extends AbstractTmfStateProvider {
        private final IGpuTraceEventLayout fLayout;
        private IGpuEventHandler fApiEventHandler;

        public GpuCallStackStateProvider(ITmfTrace trace) {
            super(trace, GpuCallStackAnalysis.ID);
            this.fLayout = ((IGpuTrace)trace).getGpuTraceEventLayout();
            this.fApiEventHandler = new ApiEventHandler();
        }

        public int getVersion() {
            return 0;
        }

        public ITmfStateProvider getNewInstance() {
            return new GpuCallStackStateProvider(this.getTrace());
        }

        protected void eventHandle(ITmfEvent event) {
            ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
            if (ssb == null) {
                return;
            }
            if (this.fLayout.isApiEvent(event)) {
                this.fApiEventHandler.handleEvent(event, ssb, this.fLayout, (ITmfStateProvider)this);
            }
        }
    }
}

