/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.felix.scr.impl.inject.ActivatorParameter;
import org.apache.felix.scr.impl.inject.LifecycleMethod;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.inject.internal.Annotations;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.inject.methods.BaseMethod;
import org.apache.felix.scr.impl.inject.methods.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.DSVersion;

public class ActivateMethod
extends BaseMethod<ActivatorParameter, Object>
implements LifecycleMethod {
    protected final boolean m_supportsInterfaces;

    public ActivateMethod(String methodName, boolean methodRequired, Class<?> componentClass, DSVersion dsVersion, boolean configurableServiceProperties, boolean supportsInterfaces) {
        super(methodName, methodRequired, componentClass, dsVersion, configurableServiceProperties);
        this.m_supportsInterfaces = supportsInterfaces;
    }

    @Override
    protected BaseMethod.MethodInfo<Object> doFindMethod(Class<?> targetClass, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        boolean suitableMethodNotAccessible = false;
        try {
            Method method = this.getMethod(targetClass, this.getMethodName(), new Class[]{ClassUtils.COMPONENT_CONTEXT_CLASS}, acceptPrivate, acceptPackage, logger);
            if (method != null) {
                return new BaseMethod.MethodInfo<Object>(method);
            }
        }
        catch (SuitableMethodNotAccessibleException thrown) {
            logger.log(InternalLogger.Level.DEBUG, "SuitableMethodNotAccessible", thrown);
            suitableMethodNotAccessible = true;
        }
        if (this.getDSVersion().isDS11()) {
            List<Method> methods = this.getSortedMethods(targetClass);
            for (Method m : methods) {
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (parameterTypes.length == 1) {
                    Class<?> type = parameterTypes[0];
                    if (type == ClassUtils.BUNDLE_CONTEXT_CLASS) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (this.getDSVersion().isDS13() && this.isAnnotation(type)) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type == ClassUtils.MAP_CLASS) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type == Integer.TYPE) {
                        if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                            return new BaseMethod.MethodInfo<Object>(m);
                        }
                        suitableMethodNotAccessible = true;
                    }
                    if (type != Integer.class) continue;
                    if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        return new BaseMethod.MethodInfo<Object>(m);
                    }
                    suitableMethodNotAccessible = true;
                    continue;
                }
                if (parameterTypes.length > 1) {
                    boolean accept = true;
                    for (Class<?> type : parameterTypes) {
                        boolean bl = accept = type == ClassUtils.COMPONENT_CONTEXT_CLASS || type == ClassUtils.BUNDLE_CONTEXT_CLASS || type == ClassUtils.MAP_CLASS || this.isDeactivate() && (type == Integer.TYPE || type == Integer.class) || this.getDSVersion().isDS13() && this.isAnnotation(type);
                        if (!accept) break;
                    }
                    if (!accept) continue;
                    if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                        return new BaseMethod.MethodInfo<Object>(m);
                    }
                    suitableMethodNotAccessible = true;
                    continue;
                }
                if (ActivateMethod.accept(m, acceptPrivate, acceptPackage, this.returnValue())) {
                    return new BaseMethod.MethodInfo<Object>(m);
                }
                suitableMethodNotAccessible = true;
            }
        }
        if (suitableMethodNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    @Override
    protected void setTypes(Object types) {
    }

    boolean isDeactivate() {
        return false;
    }

    List<Method> getSortedMethods(Class<?> targetClass) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : methods = targetClass.getDeclaredMethods()) {
            if (!m.getName().equals(this.getMethodName())) continue;
            result.add(m);
        }
        Collections.sort(result, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                int l1 = m1.getParameterTypes().length;
                int l2 = m2.getParameterTypes().length;
                if (l1 == 0) {
                    return l2;
                }
                if (l2 == 0) {
                    return -l1;
                }
                if (l1 == 1 && l2 == 1) {
                    Class<?> t1 = m1.getParameterTypes()[0];
                    Class<?> t2 = m2.getParameterTypes()[0];
                    if (t1 == ClassUtils.COMPONENT_CONTEXT_CLASS) {
                        return -1;
                    }
                    if (t2 == ClassUtils.COMPONENT_CONTEXT_CLASS) {
                        return 1;
                    }
                    if (t1 == ClassUtils.BUNDLE_CONTEXT_CLASS) {
                        return -1;
                    }
                    if (t2 == ClassUtils.BUNDLE_CONTEXT_CLASS) {
                        return 1;
                    }
                    if (ActivateMethod.this.isAnnotation(t1)) {
                        return ActivateMethod.this.isAnnotation(t2) ? 0 : -1;
                    }
                    if (ActivateMethod.this.isAnnotation(t2)) {
                        return 1;
                    }
                    if (t1 == ClassUtils.MAP_CLASS) {
                        return -1;
                    }
                    if (t2 == ClassUtils.MAP_CLASS) {
                        return 1;
                    }
                    if (t1 == Integer.TYPE) {
                        return -1;
                    }
                    if (t2 == Integer.TYPE) {
                        return 1;
                    }
                    if (t1 == Integer.class) {
                        return -1;
                    }
                    if (t2 == Integer.class) {
                        return 1;
                    }
                    return 0;
                }
                return l1 - l2;
            }
        });
        return result;
    }

    private boolean isAnnotation(Class<?> t1) {
        return t1.isAnnotation() || this.m_supportsInterfaces && t1.isInterface() && t1 != ClassUtils.MAP_CLASS;
    }

    @Override
    protected Object[] getParameters(Method method, ActivatorParameter rawParameter) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        ActivatorParameter ap = rawParameter;
        Object[] param = new Object[parameterTypes.length];
        for (int i = 0; i < param.length; ++i) {
            param[i] = parameterTypes[i] == ClassUtils.COMPONENT_CONTEXT_CLASS ? ap.getComponentContext() : (parameterTypes[i] == ClassUtils.BUNDLE_CONTEXT_CLASS ? ap.getComponentContext().getBundleContext() : (parameterTypes[i] == ClassUtils.MAP_CLASS ? ap.getComponentContext().getProperties() : (parameterTypes[i] == ClassUtils.INTEGER_CLASS || parameterTypes[i] == Integer.TYPE ? Integer.valueOf(ap.getReason()) : Annotations.toObject(parameterTypes[i], ap.getComponentContext().getPropertiesMap(), ap.getComponentContext().getBundleContext().getBundle(), this.m_supportsInterfaces))));
        }
        return param;
    }

    @Override
    protected String getMethodNamePrefix() {
        return "activate";
    }

    @Override
    public MethodResult invoke(Object componentInstance, ScrComponentContext componentContext, int reason, MethodResult methodCallFailureResult) {
        return this.invoke(componentInstance, new ActivatorParameter(componentContext, reason), methodCallFailureResult);
    }

    @Override
    public MethodResult invoke(Object componentInstance, ActivatorParameter rawParameter, MethodResult methodCallFailureResult) {
        if (this.methodExists(rawParameter.getComponentContext().getLogger())) {
            return super.invoke(componentInstance, rawParameter, methodCallFailureResult);
        }
        return null;
    }
}

