/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.indexer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.ICheckpointCollection;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;

public class TmfMemoryIndex
implements ITmfCheckpointIndex,
ICheckpointCollection {
    private final List<ITmfCheckpoint> fCheckpoints = new ArrayList<ITmfCheckpoint>();
    private TmfTimeRange fTimeRange = new TmfTimeRange(TmfTimestamp.ZERO, TmfTimestamp.ZERO);
    private long fNbEvents = 0L;

    public TmfMemoryIndex(ITmfTrace trace) {
    }

    @Override
    public void dispose() {
        this.fCheckpoints.clear();
    }

    @Override
    public void insert(ITmfCheckpoint checkpoint) {
        this.fCheckpoints.add(checkpoint);
    }

    @Override
    public ITmfCheckpoint get(long checkpoint) {
        return this.fCheckpoints.get((int)checkpoint);
    }

    @Override
    public long binarySearch(ITmfCheckpoint checkpoint) {
        return Collections.binarySearch(this.fCheckpoints, checkpoint);
    }

    @Override
    public boolean isEmpty() {
        return this.fCheckpoints.isEmpty();
    }

    @Override
    public int size() {
        return this.fCheckpoints.size();
    }

    @Override
    public boolean isCreatedFromScratch() {
        return true;
    }

    @Override
    public void setTimeRange(TmfTimeRange timeRange) {
        this.fTimeRange = timeRange;
    }

    @Override
    public void setNbEvents(long nbEvents) {
        this.fNbEvents = nbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public void delete() {
    }
}

