/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConceptDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;

public class CPPASTConceptDefinition
extends CPPASTAttributeOwner
implements ICPPASTConceptDefinition {
    private IASTName name;
    private IASTExpression expression;

    public CPPASTConceptDefinition(IASTName name, IASTExpression expr) {
        this.setName(name);
        this.setExpression(expr);
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(CONCEPT_NAME);
        }
        this.name = name;
    }

    @Override
    public int getRoleForName(IASTName name) {
        if (this.getName() == name) {
            return 2;
        }
        return 3;
    }

    @Override
    public IASTExpression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(IASTExpression expr) {
        this.assertNotFrozen();
        this.expression = expr;
        if (expr != null) {
            expr.setParent(this);
            expr.setPropertyInParent(CONSTRAINT_EXPRESSION);
        }
    }

    @Override
    public ICPPASTConceptDefinition copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ICPPASTConceptDefinition copy(IASTNode.CopyStyle style) {
        IASTName nameCopy = this.name == null ? null : this.name.copy(style);
        IASTExpression expressionCopy = this.expression == null ? null : this.expression.copy(style);
        CPPASTConceptDefinition copy = new CPPASTConceptDefinition(nameCopy, expressionCopy);
        return this.copy(copy, style);
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.expression != null && !this.expression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

