/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.cpp;

import java.util.Map;
import org.eclipse.cdt.core.dom.parser.GNUScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.GCCKeywords;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.Keywords;

public class GPPScannerExtensionConfiguration
extends GNUScannerExtensionConfiguration {
    private static final int VERSION_4_2 = GPPScannerExtensionConfiguration.version(4, 2);
    private static final int VERSION_4_3 = GPPScannerExtensionConfiguration.version(4, 3);
    private static final int VERSION_4_6 = GPPScannerExtensionConfiguration.version(4, 6);
    private static final int VERSION_4_7 = GPPScannerExtensionConfiguration.version(4, 7);
    private static final int VERSION_5_0 = GPPScannerExtensionConfiguration.version(5, 0);
    private static final int VERSION_6_0 = GPPScannerExtensionConfiguration.version(6, 0);
    private static final int VERSION_8_0 = GPPScannerExtensionConfiguration.version(8, 0);
    private static final int VERSION_10_0 = GPPScannerExtensionConfiguration.version(10, 0);
    private static final int VERSION_11_1 = GPPScannerExtensionConfiguration.version(11, 1);
    private static final int VERSION_14_0 = GPPScannerExtensionConfiguration.version(14, 0);
    private static GPPScannerExtensionConfiguration CONFIG = new GPPScannerExtensionConfiguration();
    private static GPPScannerExtensionConfiguration CONFIG_4_2 = new GPPScannerExtensionConfiguration(VERSION_4_2);
    private static GPPScannerExtensionConfiguration CONFIG_4_3 = new GPPScannerExtensionConfiguration(VERSION_4_3);
    private static GPPScannerExtensionConfiguration CONFIG_4_6 = new GPPScannerExtensionConfiguration(VERSION_4_6);
    private static GPPScannerExtensionConfiguration CONFIG_4_7 = new GPPScannerExtensionConfiguration(VERSION_4_7);
    private static GPPScannerExtensionConfiguration CONFIG_5_0 = new GPPScannerExtensionConfiguration(VERSION_5_0);
    private static GPPScannerExtensionConfiguration CONFIG_6_0 = new GPPScannerExtensionConfiguration(VERSION_6_0);
    private static GPPScannerExtensionConfiguration CONFIG_8_0 = new GPPScannerExtensionConfiguration(VERSION_8_0);
    private static GPPScannerExtensionConfiguration CONFIG_10_0 = new GPPScannerExtensionConfiguration(VERSION_10_0);
    private static GPPScannerExtensionConfiguration CONFIG_11_1 = new GPPScannerExtensionConfiguration(VERSION_11_1);
    private static GPPScannerExtensionConfiguration CONFIG_14_0 = new GPPScannerExtensionConfiguration(VERSION_14_0);
    private static GPPScannerExtensionConfiguration CONFIG_CLANG = new GPPScannerExtensionConfiguration(CompilerType.Clang, 0);
    private static GPPScannerExtensionConfiguration CONFIG_CLANG_CL = new GPPScannerExtensionConfiguration(CompilerType.ClangCl, 0);
    private static GPPScannerExtensionConfiguration CONFIG_MSVC = new GPPScannerExtensionConfiguration(CompilerType.MSVC, 0);

    public static GPPScannerExtensionConfiguration getInstance() {
        return CONFIG;
    }

    public static GPPScannerExtensionConfiguration getInstance(IScannerInfo info) {
        if (info != null) {
            try {
                int minor;
                boolean hasMsc;
                Map<String, String> definedSymbols = info.getDefinedSymbols();
                String clang = definedSymbols.get("__clang__");
                String mscVer = definedSymbols.get("_MSC_VER");
                boolean bl = hasMsc = mscVer != null && Integer.valueOf(mscVer) > 0;
                if (clang != null && Integer.valueOf(clang) > 0) {
                    if (hasMsc) {
                        return CONFIG_CLANG_CL;
                    }
                    return CONFIG_CLANG;
                }
                if (hasMsc) {
                    return CONFIG_MSVC;
                }
                int major = Integer.valueOf(definedSymbols.get("__GNUC__"));
                int version = GPPScannerExtensionConfiguration.version(major, minor = Integer.valueOf(definedSymbols.get("__GNUC_MINOR__")).intValue());
                if (version >= VERSION_11_1) {
                    return CONFIG_11_1;
                }
                if (version >= VERSION_10_0) {
                    return CONFIG_10_0;
                }
                if (version >= VERSION_8_0) {
                    return CONFIG_8_0;
                }
                if (version >= VERSION_6_0) {
                    return CONFIG_6_0;
                }
                if (version >= VERSION_5_0) {
                    return CONFIG_5_0;
                }
                if (version >= VERSION_4_7) {
                    return CONFIG_4_7;
                }
                if (version >= VERSION_4_6) {
                    return CONFIG_4_6;
                }
                if (version >= VERSION_4_3) {
                    return CONFIG_4_3;
                }
                if (version >= VERSION_4_2) {
                    return CONFIG_4_2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return CONFIG;
    }

    public GPPScannerExtensionConfiguration() {
        this(CompilerType.GCC, 0);
    }

    public GPPScannerExtensionConfiguration(int version) {
        this(CompilerType.GCC, version);
    }

    public GPPScannerExtensionConfiguration(CompilerType compiler, int version) {
        this.addMacro("__null", "0");
        this.addMacro("__builtin_offsetof(T,m)", "(reinterpret_cast <size_t>(&reinterpret_cast <const volatile char &>(static_cast<T*> (0)->m)))");
        this.addKeyword(Keywords.c_COMPLEX, 135);
        this.addKeyword(Keywords.c_IMAGINARY, 136);
        if (compiler != CompilerType.MSVC && compiler != CompilerType.ClangCl) {
            this.addMacro("__STDC__", "1");
        }
        if (compiler == CompilerType.GCC) {
            if (version >= VERSION_4_2) {
                this.addKeyword(GCCKeywords.cp_decimal32, 179);
                this.addKeyword(GCCKeywords.cp_decimal64, 180);
                this.addKeyword(GCCKeywords.cp_decimal128, 181);
            }
            if (version >= VERSION_4_3) {
                this.addKeyword(GCCKeywords.cp__has_nothrow_assign, 156);
                this.addKeyword(GCCKeywords.cp__has_nothrow_constructor, 158);
                this.addKeyword(GCCKeywords.cp__has_nothrow_copy, 157);
                this.addKeyword(GCCKeywords.cp__has_trivial_assign, 159);
                this.addKeyword(GCCKeywords.cp__has_trivial_constructor, 161);
                this.addKeyword(GCCKeywords.cp__has_trivial_copy, 160);
                this.addKeyword(GCCKeywords.cp__has_trivial_destructor, 162);
                this.addKeyword(GCCKeywords.cp__has_virtual_destructor, 163);
                this.addKeyword(GCCKeywords.cp__is_abstract, 164);
                this.addKeyword(GCCKeywords.cp__is_base_of, 165);
                this.addKeyword(GCCKeywords.cp__is_class, 166);
                this.addKeyword(GCCKeywords.cp__is_empty, 167);
                this.addKeyword(GCCKeywords.cp__is_enum, 168);
                this.addKeyword(GCCKeywords.cp__is_pod, 169);
                this.addKeyword(GCCKeywords.cp__is_polymorphic, 170);
                this.addKeyword(GCCKeywords.cp__is_union, 171);
            }
            if (version >= VERSION_4_6) {
                this.addKeyword(GCCKeywords.cp__is_literal_type, 172);
                this.addKeyword(GCCKeywords.cp__is_standard_layout, 173);
                this.addKeyword(GCCKeywords.cp__is_trivial, 174);
            }
            if (version >= VERSION_4_7) {
                this.addKeyword(GCCKeywords.cp__float128, 176);
                this.addKeyword(GCCKeywords.cp__int128, 175);
                this.addKeyword(GCCKeywords.cp__is_final, 177);
                this.addKeyword(GCCKeywords.cp__underlying_type, 178);
            }
            if (version >= VERSION_5_0) {
                this.addKeyword(GCCKeywords.cp__is_trivially_copyable, 182);
                this.addKeyword(GCCKeywords.cp__is_trivially_constructible, 183);
                this.addKeyword(GCCKeywords.cp__is_trivially_assignable, 184);
            }
            if (version >= VERSION_6_0) {
                this.addKeyword(GCCKeywords.cp__is_same_as, 187);
            }
            if (version >= VERSION_8_0) {
                this.addKeyword(GCCKeywords.cp__has_unique_object_representations, 192);
                this.addKeyword(GCCKeywords.cp__is_aggregate, 188);
                this.addKeyword(GCCKeywords.cp__is_assignable, 189);
                this.addKeyword(GCCKeywords.cp__is_constructible, 185);
                this.addKeyword(GCCKeywords.cp__integer_pack, 186);
            }
            if (version >= VERSION_10_0) {
                this.addKeyword(GCCKeywords.cp__is_same, 187);
            }
            if (version >= VERSION_11_1) {
                this.addKeyword(GCCKeywords.cp__is_nothrow_assignable, 190);
                this.addKeyword(GCCKeywords.cp__is_nothrow_constructible, 191);
            }
            if (version >= VERSION_14_0) {
                this.addKeyword(GCCKeywords.cp__is_function, 193);
            }
        } else if (compiler == CompilerType.Clang || compiler == CompilerType.ClangCl) {
            this.addKeyword(GCCKeywords.cp__has_nothrow_assign, 156);
            this.addKeyword(GCCKeywords.cp__has_nothrow_copy, 157);
            this.addKeyword(GCCKeywords.cp__has_nothrow_constructor, 158);
            this.addKeyword(GCCKeywords.cp__has_trivial_assign, 159);
            this.addKeyword(GCCKeywords.cp__has_trivial_copy, 160);
            this.addKeyword(GCCKeywords.cp__has_trivial_constructor, 161);
            this.addKeyword(GCCKeywords.cp__has_trivial_destructor, 162);
            this.addKeyword(GCCKeywords.cp__has_unique_object_representations, 192);
            this.addKeyword(GCCKeywords.cp__has_virtual_destructor, 163);
            this.addKeyword(GCCKeywords.cp__is_abstract, 164);
            this.addKeyword(GCCKeywords.cp__is_aggregate, 188);
            this.addKeyword(GCCKeywords.cp__is_assignable, 189);
            this.addKeyword(GCCKeywords.cp__is_base_of, 165);
            this.addKeyword(GCCKeywords.cp__is_class, 166);
            this.addKeyword(GCCKeywords.cp__is_constructible, 185);
            this.addKeyword(GCCKeywords.cp__is_empty, 167);
            this.addKeyword(GCCKeywords.cp__is_enum, 168);
            this.addKeyword(GCCKeywords.cp__is_final, 177);
            this.addKeyword(GCCKeywords.cp__is_function, 193);
            this.addKeyword(GCCKeywords.cp__is_literal, 172);
            this.addKeyword(GCCKeywords.cp__is_literal_type, 172);
            this.addKeyword(GCCKeywords.cp__is_nothrow_assignable, 190);
            this.addKeyword(GCCKeywords.cp__is_nothrow_constructible, 191);
            this.addKeyword(GCCKeywords.cp__is_pod, 169);
            this.addKeyword(GCCKeywords.cp__is_polymorphic, 170);
            this.addKeyword(GCCKeywords.cp__is_same, 187);
            this.addKeyword(GCCKeywords.cp__is_same_as, 187);
            this.addKeyword(GCCKeywords.cp__is_standard_layout, 173);
            this.addKeyword(GCCKeywords.cp__is_trivial, 174);
            this.addKeyword(GCCKeywords.cp__is_trivially_assignable, 184);
            this.addKeyword(GCCKeywords.cp__is_trivially_constructible, 183);
            this.addKeyword(GCCKeywords.cp__is_trivially_copyable, 182);
            this.addKeyword(GCCKeywords.cp__is_union, 171);
            this.addKeyword(GCCKeywords.cp__underlying_type, 178);
            this.addKeyword(GCCKeywords.cp__integer_pack, 186);
            this.addKeyword(GCCKeywords.cp__float128, 176);
            this.addKeyword(GCCKeywords.cp__int128, 175);
        } else if (compiler == CompilerType.MSVC) {
            this.addKeyword(GCCKeywords.cp__has_nothrow_assign, 156);
            this.addKeyword(GCCKeywords.cp__has_nothrow_constructor, 158);
            this.addKeyword(GCCKeywords.cp__has_nothrow_copy, 157);
            this.addKeyword(GCCKeywords.cp__has_trivial_assign, 159);
            this.addKeyword(GCCKeywords.cp__has_trivial_constructor, 161);
            this.addKeyword(GCCKeywords.cp__has_trivial_copy, 160);
            this.addKeyword(GCCKeywords.cp__has_trivial_destructor, 162);
            this.addKeyword(GCCKeywords.cp__has_virtual_destructor, 163);
            this.addKeyword(GCCKeywords.cp__is_abstract, 164);
            this.addKeyword(GCCKeywords.cp__is_base_of, 165);
            this.addKeyword(GCCKeywords.cp__is_class, 166);
            this.addKeyword(GCCKeywords.cp__is_empty, 167);
            this.addKeyword(GCCKeywords.cp__is_enum, 168);
            this.addKeyword(GCCKeywords.cp__is_pod, 169);
            this.addKeyword(GCCKeywords.cp__is_polymorphic, 170);
            this.addKeyword(GCCKeywords.cp__is_union, 171);
            this.addKeyword(GCCKeywords.cp__is_final, 177);
            this.addKeyword(GCCKeywords.cp__underlying_type, 178);
            this.addKeyword(GCCKeywords.cp__is_trivially_constructible, 183);
            this.addKeyword(GCCKeywords.cp__is_trivially_assignable, 184);
            this.addKeyword(GCCKeywords.cp__is_constructible, 185);
            this.addKeyword(GCCKeywords.cp__is_standard_layout, 173);
            this.addKeyword(GCCKeywords.cp__is_literal_type, 172);
            this.addKeyword(GCCKeywords.cp__is_trivial, 174);
            this.addKeyword(GCCKeywords.cp__is_trivially_copyable, 182);
        }
    }

    @Override
    public boolean supportMinAndMaxOperators() {
        return true;
    }

    @Override
    public boolean supportRawStringLiterals() {
        return true;
    }

    @Override
    public boolean supportUserDefinedLiterals() {
        return true;
    }

    @Override
    public boolean supportDigitSeparators() {
        return true;
    }

    private static enum CompilerType {
        GCC,
        Clang,
        ClangCl,
        MSVC;

    }
}

