/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested;

import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.ee8.nested.QuietServletException;
import org.eclipse.jetty.ee8.nested.UserIdentityScope;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.Request;

public interface Authentication
extends Request.AuthenticationState {
    public static final Authentication UNAUTHENTICATED = new Authentication(){

        public String toString() {
            return "UNAUTHENTICATED";
        }
    };
    public static final Authentication NOT_CHECKED = new Authentication(){

        public String toString() {
            return "NOT CHECKED";
        }
    };
    public static final Authentication SEND_CONTINUE = new Challenge(){

        public String toString() {
            return "CHALLENGE";
        }
    };
    public static final Authentication SEND_FAILURE = new Failure(){

        public String toString() {
            return "FAILURE";
        }
    };
    public static final Authentication SEND_SUCCESS = new SendSuccess(){

        public String toString() {
            return "SEND_SUCCESS";
        }
    };

    public static interface NonAuthenticated
    extends LoginAuthentication {
    }

    public static interface SendSuccess
    extends ResponseSent {
    }

    public static interface Failure
    extends ResponseSent {
    }

    public static interface Challenge
    extends ResponseSent {
    }

    public static interface ResponseSent
    extends Authentication {
    }

    public static interface Deferred
    extends LoginAuthentication,
    LogoutAuthentication {
        public Authentication authenticate(ServletRequest var1);

        public Authentication authenticate(ServletRequest var1, ServletResponse var2);
    }

    public static interface LogoutAuthentication
    extends Authentication {
        public Authentication logout(ServletRequest var1);
    }

    public static interface LoginAuthentication
    extends Authentication {
        public Authentication login(String var1, Object var2, ServletRequest var3);
    }

    public static interface Wrapped
    extends Authentication {
        public HttpServletRequest getHttpServletRequest();

        public HttpServletResponse getHttpServletResponse();
    }

    public static interface User
    extends LogoutAuthentication {
        public String getAuthMethod();

        public UserIdentity getUserIdentity();

        public boolean isUserInRole(UserIdentityScope var1, String var2);

        default public Principal getUserPrincipal() {
            UserIdentity user = this.getUserIdentity();
            return user == null ? null : user.getUserPrincipal();
        }
    }

    public static class Failed
    extends QuietServletException {
        public Failed(String message) {
            super(message);
        }
    }
}

