/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.reports;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.reports.IReportDataProvider;
import org.eclipse.tracecompass.incubator.analysis.core.reports.ImageReportDataProvider;
import org.eclipse.tracecompass.incubator.analysis.core.reports.ReportsDataProviderRegistry;
import org.eclipse.tracecompass.incubator.internal.analysis.core.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.config.ITmfDataProviderConfigurator;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigParamDescriptor;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfigurationSourceType;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.eclipse.tracecompass.tmf.core.model.DataProviderCapabilities;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class ReportsDataProviderFactory
implements IDataProviderFactory,
ITmfDataProviderConfigurator,
IReportDataProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.analysis.core.reports.reportsDataProviderFactory";
    private static final String NAME = "Reports";
    private static final String DESCRIPTION = "Configure various types of reports (text, image, etc.) or report folders for grouping purposes";
    private static final ITmfConfigurationSourceType CONFIGURATION_SOURCE_TYPE;
    private static final String CONFIGURATION_ID = "org.eclipse.tracecompass.incubator.analysis.core.reports.folder.config";
    private static final String CONFIGURATION_NAME = "Reports Folder Configurator";
    private static final String CONFIGURATION_DESCRIPTION = "Configure custom report folders (i.e., for grouping the reports)";
    private static final String PARENT_ID = "parentId";
    private static final String PARENT_ID_DESC = "The parent report ID";
    private static final Table<String, UUID, ITmfConfiguration> fTmfConfigurationTable;
    private static final Table<UUID, String, String> fTmfConfigurationHierarchy;
    private static final IDataProviderDescriptor DESCRIPTOR;

    static {
        fTmfConfigurationTable = HashBasedTable.create();
        fTmfConfigurationHierarchy = HashBasedTable.create();
        ReportsDataProviderRegistry.registerProvider(new ImageReportDataProvider());
        CONFIGURATION_SOURCE_TYPE = new TmfConfigurationSourceType.Builder().setId(CONFIGURATION_ID).setName(CONFIGURATION_NAME).setDescription(CONFIGURATION_DESCRIPTION).build();
        DESCRIPTOR = new DataProviderDescriptor.Builder().setId(ID).setName(NAME).setDescription(DESCRIPTION).setProviderType(IDataProviderDescriptor.ProviderType.NONE).setCapabilities(new DataProviderCapabilities.Builder().setCanCreate(true).build()).build();
    }

    public ReportsDataProviderFactory() {
        TmfSignalManager.register((Object)this);
        ReportsDataProviderRegistry.registerProvider(this);
        Activator.getInstance().logInfo("Reports data provider factory initialized");
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(@NonNull ITmfTrace trace) {
        return null;
    }

    public Collection<IDataProviderDescriptor> getDescriptors(ITmfTrace trace) {
        ArrayList<IDataProviderDescriptor> list = new ArrayList<IDataProviderDescriptor>();
        list.add(DESCRIPTOR);
        fTmfConfigurationTable.column((Object)trace.getUUID()).values().stream().map(config -> {
            try {
                IReportDataProvider.ReportProviderType type = ReportsDataProviderFactory.getReportType(config);
                IReportDataProvider provider = ReportsDataProviderRegistry.getProvider(type);
                return provider != null ? Map.entry(config, provider) : null;
            }
            catch (TmfConfigurationException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(entry -> ((IReportDataProvider)entry.getValue()).getDescriptorFromConfig(trace, (ITmfConfiguration)entry.getKey())).forEach(list::add);
        list.sort(Comparator.comparing(IDataProviderDescriptor::getName));
        return list.stream().map(descriptor -> descriptor.getConfiguration() == null ? descriptor : ReportsDataProviderFactory.createDescriptor(descriptor)).collect(Collectors.toList());
    }

    private static IDataProviderDescriptor createDescriptor(IDataProviderDescriptor descriptor) {
        ITmfConfiguration config = descriptor.getConfiguration();
        if (config == null) {
            return descriptor;
        }
        HashMap params = new HashMap(config.getParameters());
        String parentId = (String)params.get(PARENT_ID);
        if (parentId == null) {
            parentId = ID;
        }
        return new DataProviderDescriptor.Builder().setId(descriptor.getId()).setParentId(parentId).setName(descriptor.getName()).setDescription(descriptor.getDescription()).setProviderType(descriptor.getType()).setCapabilities(descriptor.getCapabilities()).setConfiguration(new TmfConfiguration.Builder().setId(config.getId()).setSourceTypeId(config.getSourceTypeId()).setName(config.getName()).setDescription(config.getDescription()).setParameters(params).build()).build();
    }

    public @NonNull IDataProviderDescriptor createDataProviderDescriptors(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        Activator.getInstance().logInfo("Creating data provider descriptor for trace: " + trace.getName());
        ITmfConfiguration config = this.validateConfiguration(trace, configuration);
        IReportDataProvider.ReportProviderType type = ReportsDataProviderFactory.getReportType(config);
        if (type == IReportDataProvider.ReportProviderType.NONE) {
            return this.createDescriptor(trace, config);
        }
        IReportDataProvider provider = ReportsDataProviderRegistry.getProvider(type);
        if (provider == null) {
            throw new TmfConfigurationException("Unsupported report type: " + String.valueOf((Object)type));
        }
        IDataProviderDescriptor descriptor = provider.createDescriptor(trace, config);
        fTmfConfigurationTable.put((Object)config.getId(), (Object)trace.getUUID(), (Object)config);
        String parentId = (String)config.getParameters().get(PARENT_ID);
        if (parentId == null) {
            parentId = ID;
        }
        fTmfConfigurationHierarchy.put((Object)trace.getUUID(), (Object)config.getId(), (Object)parentId);
        ReportsDataProviderFactory.writeConfiguration(trace, config);
        Activator.getInstance().logInfo("Created data provider descriptor: " + descriptor.getName() + " for trace: " + trace.getName());
        return descriptor;
    }

    public void removeDataProviderDescriptor(@NonNull ITmfTrace trace, @NonNull IDataProviderDescriptor descriptor) throws TmfConfigurationException {
        Activator.getInstance().logInfo("Removing data provider descriptor: " + descriptor.getName() + " for trace: " + trace.getName());
        ITmfConfiguration config = descriptor.getConfiguration();
        if (config == null) {
            throw new TmfConfigurationException("Data provider was not created by a configuration");
        }
        IReportDataProvider.ReportProviderType type = ReportsDataProviderFactory.getReportType(config);
        if (type == IReportDataProvider.ReportProviderType.NONE) {
            this.removeDescriptor(trace, config);
        } else {
            IReportDataProvider provider = ReportsDataProviderRegistry.getProvider(type);
            if (provider != null) {
                provider.removeDescriptor(trace, config);
            }
            ReportsDataProviderFactory.removeConfiguration(trace, config);
            fTmfConfigurationTable.remove((Object)config.getId(), (Object)trace.getUUID());
            fTmfConfigurationHierarchy.remove((Object)trace.getUUID(), (Object)config.getId());
        }
    }

    public @NonNull List<@NonNull ITmfConfigurationSourceType> getConfigurationSourceTypes() {
        ArrayList<ITmfConfigurationSourceType> result = new ArrayList<ITmfConfigurationSourceType>();
        for (IReportDataProvider provider : ReportsDataProviderRegistry.getProviders()) {
            ITmfConfigurationSourceType sourceType = provider.getConfigurationSourceType();
            ArrayList<ITmfConfigParamDescriptor> allDescriptors = new ArrayList<ITmfConfigParamDescriptor>(sourceType.getConfigParamDescriptors());
            allDescriptors.addAll(List.of(new TmfConfigParamDescriptor.Builder().setKeyName(PARENT_ID).setDescription(PARENT_ID_DESC).setIsRequired(false).build()));
            result.add(new TmfConfigurationSourceType.Builder().setName(sourceType.getName()).setDescription(sourceType.getDescription()).setId(sourceType.getId()).setConfigParamDescriptors(allDescriptors).build());
        }
        return result;
    }

    @Override
    public IReportDataProvider.ReportProviderType getReportType() {
        return IReportDataProvider.ReportProviderType.NONE;
    }

    @Override
    public ITmfConfigurationSourceType getConfigurationSourceType() {
        return CONFIGURATION_SOURCE_TYPE;
    }

    @Override
    public @NonNull IDataProviderDescriptor createDescriptor(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        ITmfConfiguration config = this.validateConfiguration(trace, configuration);
        IDataProviderDescriptor descriptor = new DataProviderDescriptor.Builder().setId(config.getId()).setName(config.getName()).setDescription(config.getDescription()).setProviderType(IDataProviderDescriptor.ProviderType.NONE).setConfiguration(config).setCapabilities(new DataProviderCapabilities.Builder().setCanCreate(false).setCanDelete(true).build()).build();
        fTmfConfigurationTable.put((Object)config.getId(), (Object)trace.getUUID(), (Object)config);
        String parentId = (String)config.getParameters().get(PARENT_ID);
        if (parentId == null) {
            parentId = ID;
        }
        fTmfConfigurationHierarchy.put((Object)trace.getUUID(), (Object)config.getId(), (Object)parentId);
        ReportsDataProviderFactory.writeConfiguration(trace, config);
        return descriptor;
    }

    @Override
    public @NonNull IDataProviderDescriptor getDescriptorFromConfig(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) {
        return new DataProviderDescriptor.Builder().setId(configuration.getId()).setName(configuration.getName()).setDescription(configuration.getDescription()).setProviderType(IDataProviderDescriptor.ProviderType.NONE).setConfiguration(configuration).setCapabilities(new DataProviderCapabilities.Builder().setCanCreate(false).setCanDelete(true).build()).build();
    }

    @Override
    public @NonNull IDataProviderDescriptor removeDescriptor(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        ITmfConfiguration childConfig;
        IDataProviderDescriptor descriptor = this.getDescriptorFromConfig(trace, configuration);
        ArrayList childrenToRemove = new ArrayList();
        for (Map.Entry entry : fTmfConfigurationTable.column((Object)trace.getUUID()).entrySet()) {
            childConfig = (ITmfConfiguration)entry.getValue();
            String parentId = (String)childConfig.getParameters().get(PARENT_ID);
            if (!configuration.getId().equals(parentId)) continue;
            childrenToRemove.add(entry);
        }
        for (Map.Entry entry : childrenToRemove) {
            childConfig = (ITmfConfiguration)entry.getValue();
            IReportDataProvider.ReportProviderType childType = ReportsDataProviderFactory.getReportType(childConfig);
            if (childType == IReportDataProvider.ReportProviderType.NONE) {
                this.removeDescriptor(trace, childConfig);
                continue;
            }
            IReportDataProvider provider = ReportsDataProviderRegistry.getProvider(childType);
            if (provider != null) {
                provider.removeDescriptor(trace, childConfig);
            }
            fTmfConfigurationTable.remove((Object)childConfig.getId(), (Object)trace.getUUID());
            fTmfConfigurationHierarchy.remove((Object)trace.getUUID(), (Object)childConfig.getId());
        }
        ReportsDataProviderFactory.removeConfiguration(trace, configuration);
        fTmfConfigurationTable.remove((Object)configuration.getId(), (Object)trace.getUUID());
        fTmfConfigurationHierarchy.remove((Object)trace.getUUID(), (Object)configuration.getId());
        return descriptor;
    }

    @Override
    public void validateConfiguration(@NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
    }

    private ITmfConfiguration validateConfiguration(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        IReportDataProvider.ReportProviderType parentType;
        if (configuration.getName().equals("---unknown---") || configuration.getSourceTypeId().equals("---unknown---")) {
            throw new TmfConfigurationException("Missing configuration name or type");
        }
        String parentId = (String)configuration.getParameters().get(PARENT_ID);
        if (parentId == null) {
            parentId = ID;
        }
        if (!parentId.equals(ID) && !fTmfConfigurationTable.contains((Object)parentId, (Object)trace.getUUID())) {
            throw new TmfConfigurationException("Parent configuration does not exist");
        }
        String configFullId = ReportsDataProviderFactory.getFullUUID(configuration.getId(), parentId);
        if (fTmfConfigurationTable.contains((Object)configFullId, (Object)trace.getUUID())) {
            throw new TmfConfigurationException("Configuration already exists");
        }
        IReportDataProvider.ReportProviderType reportProviderType = parentType = parentId.equals(ID) ? IReportDataProvider.ReportProviderType.NONE : ReportsDataProviderFactory.getReportType((ITmfConfiguration)fTmfConfigurationTable.get((Object)parentId, (Object)trace.getUUID()));
        if (parentType != IReportDataProvider.ReportProviderType.NONE) {
            throw new TmfConfigurationException("Parent must be a NONE report type");
        }
        this.validateNoCycles(trace, parentId, new HashSet<String>());
        return new TmfConfiguration.Builder().setId(configFullId).setSourceTypeId(configuration.getSourceTypeId()).setName(configuration.getName()).setDescription(configuration.getDescription()).setParameters(configuration.getParameters()).build();
    }

    private void validateNoCycles(ITmfTrace trace, String currentId, HashSet<String> visited) throws TmfConfigurationException {
        String parentId;
        if (!visited.add(currentId)) {
            throw new TmfConfigurationException("Circular dependency detected in report hierarchy");
        }
        ITmfConfiguration config = (ITmfConfiguration)fTmfConfigurationTable.get((Object)currentId, (Object)trace.getUUID());
        if (config != null && (parentId = (String)config.getParameters().get(PARENT_ID)) != null) {
            this.validateNoCycles(trace, parentId, visited);
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadConfigurations(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        fTmfConfigurationTable.column((Object)signal.getTrace().getUUID()).clear();
        fTmfConfigurationHierarchy.row((Object)signal.getTrace().getUUID()).clear();
    }

    private void loadConfigurations(@NonNull ITmfTrace trace) {
        String supplFolder = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        Path supplPath = new Path(supplFolder);
        File folder = (supplPath = supplPath.addTrailingSeparator().append(ID)).toFile();
        if (!folder.exists()) {
            return;
        }
        this.loadConfigurationsRecursive(trace, folder);
    }

    private void loadConfigurationsRecursive(@NonNull ITmfTrace trace, File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.loadConfigurationsRecursive(trace, file);
            } else if (file.getName().endsWith("json")) {
                try {
                    ITmfConfiguration config = TmfConfiguration.fromJsonFile((File)file);
                    try {
                        this.validateConfiguration(trace, config);
                        fTmfConfigurationTable.put((Object)config.getId(), (Object)trace.getUUID(), (Object)config);
                    }
                    catch (TmfConfigurationException e) {
                        Activator.getInstance().logError("Error validating configuration from file: " + file.getName(), (Throwable)e);
                    }
                }
                catch (TmfConfigurationException e) {
                    Activator.getInstance().logError("Error reading configuration from file: " + file.getName(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private static void writeConfiguration(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        Activator.getInstance().logInfo("Writing configuration " + configuration.getName() + " for trace " + trace.getName() + " to disk");
        IPath basePath = ReportsDataProviderFactory.getConfigurationBasePath(trace, configuration);
        File folder = basePath.toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new TmfConfigurationException("Could not create configuration directory");
        }
        TmfConfiguration.writeConfiguration((ITmfConfiguration)configuration, (IPath)basePath);
    }

    private static void removeConfiguration(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) throws TmfConfigurationException {
        Activator.getInstance().logInfo("Removing configuration " + configuration.getName() + " for trace " + trace.getName() + " from disk");
        IPath configPath = ReportsDataProviderFactory.getConfigurationBasePath(trace, configuration);
        File file = configPath.toFile();
        if (file.exists()) {
            try {
                java.nio.file.Path path = file.toPath();
                Files.walkFileTree(path, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path f, BasicFileAttributes attrs) throws IOException {
                        Files.delete(f);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(java.nio.file.Path f, IOException exc) throws IOException {
                        if (f.toFile().setWritable(true)) {
                            Files.delete(f);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }
            catch (IOException e) {
                throw new TmfConfigurationException("Could not delete configuration: " + e.getMessage());
            }
        }
    }

    public static IPath getConfigurationBasePath(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) {
        Path supplPath = new Path(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        supplPath = supplPath.addTrailingSeparator().append(ID);
        ArrayList<ITmfConfiguration> configurationChain = new ArrayList<ITmfConfiguration>();
        ITmfConfiguration currentConfig = configuration;
        while (currentConfig != null) {
            configurationChain.add(0, currentConfig);
            String parentId = (String)currentConfig.getParameters().get(PARENT_ID);
            if (parentId == null || parentId.equals(ID)) break;
            currentConfig = (ITmfConfiguration)fTmfConfigurationTable.get((Object)parentId, (Object)trace.getUUID());
        }
        for (ITmfConfiguration config : configurationChain) {
            supplPath = supplPath.addTrailingSeparator().append(config.getId());
        }
        return supplPath;
    }

    private static String getFullUUID(String configId, String parentId) {
        String combinedId = String.format("%s:%s", NonNullUtils.nullToEmptyString((Object)parentId), NonNullUtils.nullToEmptyString((Object)configId)).replaceAll("^:|:$", "");
        return UUID.nameUUIDFromBytes(combinedId.getBytes()).toString();
    }

    public static ITmfConfiguration getConfigurationParent(@NonNull ITmfTrace trace, @NonNull ITmfConfiguration configuration) {
        String parentId = (String)configuration.getParameters().get(PARENT_ID);
        return parentId == null ? null : (ITmfConfiguration)fTmfConfigurationTable.get((Object)parentId, (Object)trace.getUUID());
    }

    private static IReportDataProvider.ReportProviderType getReportType(ITmfConfiguration configuration) throws TmfConfigurationException {
        String sourceTypeId = configuration.getSourceTypeId();
        return ReportsDataProviderRegistry.getProviders().stream().filter(provider -> provider.getConfigurationSourceType().getId().equals(sourceTypeId)).findFirst().map(IReportDataProvider::getReportType).orElseThrow(() -> new TmfConfigurationException("Invalid report configuration source type"));
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
        fTmfConfigurationTable.clear();
        fTmfConfigurationHierarchy.clear();
    }
}

