/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.inputoutput;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.kernel.core.inputoutput.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DiskRequestDataProvider
extends AbstractTimeGraphDataProvider<InputOutputAnalysisModule, TimeGraphEntryModel>
implements IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.kernel.core.inputoutput.DiskRequestDataProvider";
    private static final String WAITING_QUEUE;
    private static final String DRIVER_QUEUE;
    private static final int MAX_SIZE = 500;
    private static final int NB_SIZE_STYLES = 5;
    private static final String SIZE_STYLE_PREFIX = "size";
    private static final String READ_STYLE = "read";
    private static final String WRITE_STYLE = "write";
    private static final String FLUSH_STYLE = "flush";
    private static final String OTHER_STYLE = "other";
    private static final Comparator<ITmfStateInterval> INTERVAL_COMPARATOR;
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private final Set<Integer> fRequestQuark = new TreeSet<Integer>();

    static {
        String otherColor;
        String brownColor;
        WAITING_QUEUE = Objects.requireNonNull(Messages.DiskRequestsDataProvider_WaitingQueue);
        DRIVER_QUEUE = Objects.requireNonNull(Messages.DiskRequestsDataProvider_DriverQueue);
        INTERVAL_COMPARATOR = Comparator.comparing(ITmfStateInterval::getStartTime);
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String blackColor = X11ColorUtils.toHexColor((String)"black");
        if (blackColor == null) {
            blackColor = X11ColorUtils.toHexColor((int)0, (int)0, (int)0);
        }
        if ((brownColor = X11ColorUtils.toHexColor((String)"sienna")) == null) {
            brownColor = X11ColorUtils.toHexColor((int)160, (int)82, (int)45);
        }
        if ((otherColor = X11ColorUtils.toHexColor((String)"dark green")) == null) {
            otherColor = X11ColorUtils.toHexColor((int)0, (int)100, (int)0);
        }
        builder.put((Object)READ_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)READ_STYLE, (Object)"background-color", (Object)Objects.requireNonNull(X11ColorUtils.toHexColor((String)"blue")), (Object)"color", (Object)blackColor)));
        builder.put((Object)WRITE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)WRITE_STYLE, (Object)"background-color", (Object)Objects.requireNonNull(X11ColorUtils.toHexColor((String)"red")), (Object)"color", (Object)blackColor)));
        builder.put((Object)FLUSH_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)FLUSH_STYLE, (Object)"background-color", (Object)brownColor, (Object)"height", (Object)Float.valueOf(0.6f))));
        builder.put((Object)OTHER_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)OTHER_STYLE, (Object)"background-color", (Object)otherColor, (Object)"height", (Object)Float.valueOf(0.6f))));
        int i = 0;
        while (i < 5) {
            builder.put((Object)(SIZE_STYLE_PREFIX + i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"height", (Object)Float.valueOf((float)(i + 1) / 5.0f))));
            ++i;
        }
        STYLES = builder.build();
    }

    public DiskRequestDataProvider(ITmfTrace trace, InputOutputAnalysisModule analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return true;
    }

    protected TmfTreeModel<TimeGraphEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        ArrayList<TimeGraphEntryModel> nodes = new ArrayList<TimeGraphEntryModel>();
        long rootId = this.getId(-1);
        nodes.add(new TimeGraphEntryModel(rootId, -1L, Objects.requireNonNull(this.getTrace().getName()), start, end));
        for (Integer diskQuark : ss.getQuarks(new String[]{"Disks", "*"})) {
            String diskName = DiskUtils.getDiskName((ITmfStateSystem)ss, (Integer)diskQuark);
            long diskId = this.getId(diskQuark);
            List<TimeGraphEntryModel> driverQueue = this.getDiskQueue(ss, diskQuark, "Driver_queue", DRIVER_QUEUE, diskId, start, end);
            List<TimeGraphEntryModel> waitingQueue = this.getDiskQueue(ss, diskQuark, "Waiting_queue", WAITING_QUEUE, diskId, start, end);
            if (driverQueue.isEmpty() || waitingQueue.isEmpty()) continue;
            nodes.add(new TimeGraphEntryModel(diskId, rootId, diskName, start, end));
            nodes.addAll(driverQueue);
            nodes.addAll(waitingQueue);
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    private List<TimeGraphEntryModel> getDiskQueue(ITmfStateSystem ss, Integer diskQuark, String queueAttribute, String queueName, long diskId, long start, long end) {
        List subAttributes;
        int queueQuark = ss.optQuarkRelative(diskQuark.intValue(), new String[]{queueAttribute});
        if (queueQuark == -2) {
            Collections.emptyList();
        }
        if ((subAttributes = ss.getSubAttributes(queueQuark, false)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimeGraphEntryModel> entries = new ArrayList<TimeGraphEntryModel>();
        long queueId = this.getId(queueQuark);
        entries.add(new TimeGraphEntryModel(queueId, diskId, queueName, start, end));
        for (Integer requestQuark : subAttributes) {
            this.fRequestQuark.add(requestQuark);
            entries.add(new TimeGraphEntryModel(this.getId(requestQuark), queueId, ss.getAttributeName(requestQuark.intValue()), start, end));
        }
        return entries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected @Nullable TimeGraphModel getRowModel(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        List ids = DataProviderParameterUtils.extractSelectedItems(parameters);
        if (ids == null) {
            return null;
        }
        Map selectedEntries = this.getSelectedEntries(ids);
        List times = DataProviderParameterUtils.extractTimeRequested(parameters);
        if (times == null) {
            return null;
        }
        HashMap<Integer, Predicate<Multimap<String, Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<Integer> quarksToQuery = new ArrayList<Integer>();
        ArrayList<RequestBuilder> builders = new ArrayList<RequestBuilder>();
        for (Map.Entry entry : selectedEntries.entrySet()) {
            if (!this.fRequestQuark.contains(entry.getValue())) continue;
            RequestBuilder requestBuilder = new RequestBuilder((Long)entry.getKey(), (Integer)entry.getValue(), ss);
            builders.add(requestBuilder);
            quarksToQuery.addAll(requestBuilder.getQuarks());
        }
        HashMap<Integer, Set<ITmfStateInterval>> intervals = new HashMap<Integer, Set<ITmfStateInterval>>();
        try {
            for (ITmfStateInterval interval : ss.query2D(quarksToQuery, (Collection)times)) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                intervals.computeIfAbsent(interval.getAttribute(), q -> new TreeSet<ITmfStateInterval>(INTERVAL_COMPARATOR)).add(interval);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return null;
        }
        ArrayList<ITimeGraphRowModel> models = new ArrayList<ITimeGraphRowModel>();
        for (RequestBuilder requestBuilder : builders) {
            models.add(requestBuilder.createStates(intervals, predicates, monitor));
        }
        return new TimeGraphModel(models);
    }

    private static @Nullable OutputElementStyle getStyleFor(IoOperationType type, @Nullable Integer size) {
        String typeStyle = null;
        String sizeStyle = null;
        switch (type) {
            case FLUSH: {
                typeStyle = FLUSH_STYLE;
                break;
            }
            case OTHER: {
                typeStyle = OTHER_STYLE;
                break;
            }
            case READ: {
                typeStyle = READ_STYLE;
                if (size == null) break;
                sizeStyle = SIZE_STYLE_PREFIX + Math.min(4, (int)((double)size.intValue() / 500.0 * 5.0));
                break;
            }
            case WRITE: {
                typeStyle = WRITE_STYLE;
                if (size == null) break;
                sizeStyle = SIZE_STYLE_PREFIX + Math.min(4, (int)((double)size.intValue() / 500.0 * 5.0));
                break;
            }
            default: {
                return null;
            }
        }
        String styleKey = sizeStyle == null ? typeStyle : String.valueOf(sizeStyle) + ',' + typeStyle;
        return STYLE_MAP.computeIfAbsent(styleKey, style -> new OutputElementStyle(style));
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        int sizeQuark;
        List ids = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (ids == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Map selectedEntries = this.getSelectedEntries(ids);
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null || times.isEmpty()) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        ITmfStateSystem ss = ((InputOutputAnalysisModule)this.getAnalysisModule()).getStateSystem();
        long start = (Long)times.get(0);
        if (ss == null || selectedEntries.size() != 1 || !((InputOutputAnalysisModule)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        ArrayList<Integer> quarks = new ArrayList<Integer>();
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>(1);
        Integer quark = (Integer)selectedEntries.values().iterator().next();
        retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_Sector), "");
        quarks.add(quark);
        int sectorQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"Current_request"});
        if (sectorQuark != -2) {
            retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_Sector), "");
            quarks.add(sectorQuark);
        }
        if ((sizeQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"Request_size"})) != -2) {
            retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_NbSectors), "");
            quarks.add(sizeQuark);
        }
        try {
            for (ITmfStateInterval interval : ss.query2D(quarks, start, start)) {
                Object value;
                int attribute = interval.getAttribute();
                if (attribute == sectorQuark) {
                    value = interval.getValue();
                    if (!(value instanceof Long)) continue;
                    retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_Sector), "0x" + Long.toHexString(Objects.requireNonNull((Long)value)));
                    continue;
                }
                if (attribute == sizeQuark) {
                    value = interval.getValue();
                    if (!(value instanceof Integer)) continue;
                    retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_NbSectors), String.valueOf(value));
                    continue;
                }
                if (attribute != quark) continue;
                value = interval.getValue();
                if (!(value instanceof Integer)) {
                    return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                }
                retMap.put(Objects.requireNonNull(Messages.DiskRequestDataProvider_RequestType), String.valueOf(IoOperationType.fromNumber((Integer)((Integer)value))));
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STYLES), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private final class RequestBuilder {
        private final long fId;
        private final int fMainQuark;
        private final int fSizeQuark;

        private RequestBuilder(Long id, Integer quark, ITmfStateSystem ss) {
            this.fId = id;
            this.fMainQuark = quark;
            this.fSizeQuark = ss.optQuarkRelative(quark.intValue(), new String[]{"Request_size"});
        }

        private List<Integer> getQuarks() {
            ArrayList<Integer> quarks = new ArrayList<Integer>();
            quarks.add(this.fMainQuark);
            if (this.fSizeQuark != -2) {
                quarks.add(this.fSizeQuark);
            }
            return quarks;
        }

        private @Nullable ITmfStateInterval findInterval(@Nullable Set<ITmfStateInterval> intervals, long time) {
            if (intervals == null) {
                return null;
            }
            for (ITmfStateInterval interval : intervals) {
                if (interval.getStartTime() > time) {
                    return null;
                }
                if (time < interval.getStartTime() || time > interval.getEndTime()) continue;
                return interval;
            }
            return null;
        }

        public ITimeGraphRowModel createStates(Map<Integer, Set<ITmfStateInterval>> intervals, Map<Integer, Predicate<Multimap<String, Object>>> predicates, @Nullable IProgressMonitor monitor) {
            Set<ITmfStateInterval> mainIntervals = intervals.get(this.fMainQuark);
            if (mainIntervals == null) {
                return new TimeGraphRowModel(this.fId, Collections.emptyList());
            }
            ArrayList states = new ArrayList();
            block0: for (ITmfStateInterval mainInterval : mainIntervals) {
                long startTime = mainInterval.getStartTime();
                long duration = mainInterval.getEndTime() - startTime + 1L;
                Object value = mainInterval.getValue();
                if (value == null) {
                    TimeGraphState timeGraphState = new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
                    DiskRequestDataProvider.this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, this.fId, predicates, monitor);
                    continue;
                }
                if (this.fSizeQuark == -2) {
                    TimeGraphState timeGraphState = new TimeGraphState(startTime, duration, null, DiskRequestDataProvider.getStyleFor(IoOperationType.fromNumber((Integer)((Integer)value)), null));
                    DiskRequestDataProvider.this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, this.fId, predicates, monitor);
                    continue;
                }
                long time = startTime;
                while (time < mainInterval.getEndTime()) {
                    ITmfStateInterval sizeInterval = this.findInterval(intervals.get(this.fSizeQuark), time);
                    TimeGraphState timeGraphState = new TimeGraphState(startTime, duration, null, DiskRequestDataProvider.getStyleFor(IoOperationType.fromNumber((Integer)((Integer)value)), sizeInterval == null ? null : (Integer)sizeInterval.getValue()));
                    DiskRequestDataProvider.this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, this.fId, predicates, monitor);
                    if (sizeInterval == null) continue block0;
                    time = sizeInterval.getEndTime() + 1L;
                }
            }
            return new TimeGraphRowModel(this.fId, states);
        }
    }
}

